/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.world.inventory;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.util.ComponentDecomposer;
import fuzs.easyanvils.util.FormattedStringDecomposer;
import fuzs.easyanvils.world.inventory.state.AnvilMenuState;
import fuzs.easyanvils.world.inventory.state.BuiltInAnvilMenu;
import fuzs.easyanvils.world.inventory.state.VanillaAnvilMenu;
import fuzs.easyanvils.world.level.block.entity.AnvilBlockEntity;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class ModAnvilMenu
extends AnvilMenu {
    private final Container container;
    private final AnvilMenuState builtInAnvilState;
    private final AnvilMenuState vanillaAnvilState;

    public ModAnvilMenu(int id, Inventory inventory) {
        super(id, inventory);
        this.container = new SimpleContainer(new ItemStack[0]);
        this.builtInAnvilState = new BuiltInAnvilMenu(inventory, ContainerLevelAccess.NULL);
        this.vanillaAnvilState = new VanillaAnvilMenu(inventory, ContainerLevelAccess.NULL);
        this.createResult();
    }

    public ModAnvilMenu(int id, Inventory inventory, AnvilBlockEntity blockEntity, ContainerLevelAccess containerLevelAccess) {
        super(id, inventory, containerLevelAccess);
        this.container = blockEntity;
        this.builtInAnvilState = new BuiltInAnvilMenu(inventory, containerLevelAccess);
        this.vanillaAnvilState = new VanillaAnvilMenu(inventory, containerLevelAccess);
        this.initializeSlots(blockEntity);
        this.createResult();
    }

    private void initializeSlots(AnvilBlockEntity blockEntity) {
        ((SimpleContainer)this.inputSlots).items = blockEntity.getItems();
        ((SimpleContainer)this.inputSlots).addListener($ -> blockEntity.setChanged());
        this.resultSlots.itemStacks = blockEntity.getResult();
    }

    public MenuType<?> getType() {
        return (MenuType)ModRegistry.ANVIL_MENU_TYPE.value();
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    protected boolean mayPickup(Player player, boolean hasStack) {
        return (player.getAbilities().instabuild || player.experienceLevel >= this.getCost()) && this.getCost() >= 0;
    }

    public void createResult() {
        if (this.builtInAnvilState == null || this.vanillaAnvilState == null) {
            return;
        }
        ItemStack left = this.inputSlots.getItem(0);
        ItemStack right = this.inputSlots.getItem(1);
        this.builtInAnvilState.init(left, right, this.itemName);
        this.vanillaAnvilState.init(left, right, this.itemName);
        this.builtInAnvilState.fillResultSlots();
        this.vanillaAnvilState.fillResultSlots();
        if (!AnvilMenuState.equals(this.builtInAnvilState, this.vanillaAnvilState)) {
            super.createResult();
        } else {
            this.createResult(left, right, this.itemName);
        }
    }

    private void createResult(ItemStack left, ItemStack right, String itemName) {
        this.setCost(1);
        if (left.isEmpty()) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
            this.setCost(0);
        } else {
            int maxAnvilRepairCost;
            boolean hasNoLimit;
            int allOperationsCost;
            ItemStack output = left.copy();
            Map leftEnchantments = EnchantmentHelper.getEnchantments((ItemStack)output);
            int baseRepairCost = left.getBaseRepairCost() + (right.isEmpty() ? 0 : right.getBaseRepairCost());
            baseRepairCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.priorWorkPenalty.operator.applyAsInt(baseRepairCost);
            this.repairItemCountCost = 0;
            boolean isBook = false;
            int repairOperationCost = 0;
            int enchantOperationCost = 0;
            int renameOperationCost = 0;
            if (!right.isEmpty()) {
                boolean bl = isBook = right.is(Items.ENCHANTED_BOOK) && !EnchantedBookItem.getEnchantments((ItemStack)right).isEmpty();
                if (output.isDamageableItem() && output.getItem().isValidRepairItem(left, right)) {
                    int repairMaterials;
                    int l2 = (int)Math.min((double)output.getDamageValue(), Math.floor((double)output.getMaxDamage() * ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithMaterialRestoredDurability));
                    if (l2 <= 0) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.setCost(0);
                        return;
                    }
                    for (repairMaterials = 0; l2 > 0 && repairMaterials < right.getCount(); ++repairMaterials) {
                        int j3 = output.getDamageValue() - l2;
                        output.setDamageValue(j3);
                        repairOperationCost += ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithMaterialUnitCost;
                        l2 = (int)Math.min((double)output.getDamageValue(), Math.floor((double)output.getMaxDamage() * ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithMaterialRestoredDurability));
                    }
                    this.repairItemCountCost = repairMaterials;
                } else {
                    if (!(isBook || output.is(right.getItem()) && output.isDamageableItem())) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.setCost(0);
                        return;
                    }
                    if (output.isDamageableItem() && !isBook) {
                        int l = left.getMaxDamage() - left.getDamageValue();
                        int i1 = right.getMaxDamage() - right.getDamageValue();
                        int j1 = i1 + (int)Math.floor((double)output.getMaxDamage() * ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithOtherItemBonusDurability);
                        int k1 = l + j1;
                        int l1 = output.getMaxDamage() - k1;
                        if (l1 < 0) {
                            l1 = 0;
                        }
                        if (l1 < output.getDamageValue()) {
                            output.setDamageValue(l1);
                            repairOperationCost += ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithOtherItemCost;
                        }
                    }
                    Map rightEnchantments = EnchantmentHelper.getEnchantments((ItemStack)right);
                    boolean itemWithCompatibleEnchantment = false;
                    boolean itemWithIncompatibleEnchantment = false;
                    for (Enchantment rightEnchantment : rightEnchantments.keySet()) {
                        Integer oldEnchantmentLevel;
                        int rarityCostMultiplier;
                        int enchantmentLevel;
                        if (rightEnchantment == null) continue;
                        int leftEnchantmentLevel = leftEnchantments.getOrDefault(rightEnchantment, 0);
                        enchantmentLevel = leftEnchantmentLevel == (enchantmentLevel = ((Integer)rightEnchantments.get(rightEnchantment)).intValue()) ? enchantmentLevel + 1 : Math.max(enchantmentLevel, leftEnchantmentLevel);
                        boolean compatibleWithItem = rightEnchantment.canEnchant(left);
                        if (this.player.getAbilities().instabuild || left.is(Items.ENCHANTED_BOOK)) {
                            compatibleWithItem = true;
                        }
                        for (Enchantment leftEnchantment : leftEnchantments.keySet()) {
                            if (leftEnchantment == rightEnchantment || rightEnchantment.isCompatibleWith(leftEnchantment)) continue;
                            compatibleWithItem = false;
                            ++enchantOperationCost;
                        }
                        if (!compatibleWithItem) {
                            if (repairOperationCost > 0) continue;
                            itemWithIncompatibleEnchantment = true;
                            continue;
                        }
                        itemWithCompatibleEnchantment = true;
                        if (enchantmentLevel > rightEnchantment.getMaxLevel()) {
                            enchantmentLevel = rightEnchantment.getMaxLevel();
                        }
                        int maxLevel = Math.max(leftEnchantments.getOrDefault(rightEnchantment, 0), (Integer)rightEnchantments.get(rightEnchantment));
                        if ((maxLevel = Math.max(maxLevel, enchantmentLevel)) != enchantmentLevel) {
                            enchantmentLevel = maxLevel;
                        }
                        switch (rightEnchantment.getRarity()) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case COMMON: {
                                int n = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.commonEnchantmentMultiplier;
                                break;
                            }
                            case UNCOMMON: {
                                int n = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.uncommonEnchantmentMultiplier;
                                break;
                            }
                            case RARE: {
                                int n = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.rareEnchantmentMultiplier;
                                break;
                            }
                            case VERY_RARE: {
                                int n = rarityCostMultiplier = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.veryRareEnchantmentMultiplier;
                            }
                        }
                        if (isBook && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.halvedBookCosts) {
                            rarityCostMultiplier = Math.max(1, rarityCostMultiplier / 2);
                        }
                        if ((oldEnchantmentLevel = leftEnchantments.put(rightEnchantment, enchantmentLevel)) == null || oldEnchantmentLevel != enchantmentLevel) {
                            enchantOperationCost += rarityCostMultiplier * enchantmentLevel;
                        }
                        if (left.getCount() <= 1 || this.player.getAbilities().instabuild) continue;
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.setCost(-1);
                        return;
                    }
                    if (itemWithIncompatibleEnchantment && !itemWithCompatibleEnchantment) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.setCost(0);
                        return;
                    }
                }
            }
            boolean hasRenamedItem = false;
            if (ComponentDecomposer.getStringLength(itemName) == 0) {
                if (left.hasCustomHoverName()) {
                    renameOperationCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.freeRenames.filter.test(left) ? 0 : 1;
                    hasRenamedItem = true;
                    output.resetHoverName();
                }
            } else if (!itemName.equals(ComponentDecomposer.toFormattedString(left.getHoverName()))) {
                renameOperationCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.freeRenames.filter.test(left) ? 0 : 1;
                hasRenamedItem = true;
                output.setHoverName(ComponentDecomposer.toFormattedComponent(itemName));
            }
            if (isBook && !CommonAbstractions.INSTANCE.isBookEnchantable(output, right)) {
                output = ItemStack.EMPTY;
            }
            if ((allOperationsCost = enchantOperationCost + repairOperationCost + renameOperationCost) == 0) {
                this.setCost(0);
                if (!hasRenamedItem) {
                    output = ItemStack.EMPTY;
                }
            } else if (enchantOperationCost == 0 && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.renameAndRepairCosts == ServerConfig.RenameAndRepairCost.FIXED) {
                this.setCost(allOperationsCost);
            } else {
                this.setCost(baseRepairCost + allOperationsCost);
            }
            boolean bl = hasNoLimit = (maxAnvilRepairCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.tooExpensiveLimit) == -1;
            if (hasNoLimit) {
                maxAnvilRepairCost = 40;
            }
            if (this.getCost() >= maxAnvilRepairCost) {
                if (enchantOperationCost == 0 && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.renameAndRepairCosts == ServerConfig.RenameAndRepairCost.LIMITED) {
                    this.setCost(maxAnvilRepairCost - 1);
                } else if (!hasNoLimit && !this.player.getAbilities().instabuild) {
                    output = ItemStack.EMPTY;
                }
            }
            if (!output.isEmpty()) {
                int outputRepairCost = output.getBaseRepairCost();
                if (!right.isEmpty() && outputRepairCost < right.getBaseRepairCost()) {
                    outputRepairCost = right.getBaseRepairCost();
                }
                if (!(allOperationsCost <= 0 || (enchantOperationCost <= 0 || isBook && left.is(Items.ENCHANTED_BOOK) && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.penaltyFreeEnchantsForBooks) && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.penaltyFreeRenamesAndRepairs)) {
                    outputRepairCost = AnvilMenu.calculateIncreasedRepairCost((int)outputRepairCost);
                }
                if (outputRepairCost > 0) {
                    output.setRepairCost(outputRepairCost);
                }
                EnchantmentHelper.setEnchantments((Map)leftEnchantments, (ItemStack)output);
            }
            this.resultSlots.setItem(0, output);
            this.broadcastChanges();
        }
    }

    public void setCost(int cost) {
        this.setData(0, cost);
    }

    public void removed(Player player) {
        ContainerLevelAccess containerLevelAccess = this.access;
        this.access = ContainerLevelAccess.NULL;
        super.removed(player);
        this.access = containerLevelAccess;
    }

    public boolean setItemName(String newName) {
        if (ComponentDecomposer.getStringLength(newName = FormattedStringDecomposer.filterText(newName)) <= 50 && !Objects.equals(newName, this.itemName)) {
            this.itemName = newName.trim();
            if (this.getSlot(2).hasItem()) {
                ItemStack itemStack = this.getSlot(2).getItem();
                ModAnvilMenu.setFormattedItemName(this.itemName, itemStack);
            }
            this.createResult();
            return true;
        }
        return false;
    }

    public static void setFormattedItemName(String newName, ItemStack itemStack) {
        Component component = ComponentDecomposer.toFormattedComponent(newName);
        if (component.getString().isEmpty()) {
            itemStack.resetHoverName();
        } else {
            itemStack.setHoverName(component);
        }
    }
}

