/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.world.level.block.entity;

import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.world.inventory.ModAnvilMenu;
import fuzs.puzzleslib.api.container.v1.ContainerImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AnvilBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
ContainerImpl {
    public static final MutableComponent REPAIR_COMPONENT = Component.translatable((String)"container.repair");
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> result = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    public AnvilBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.ANVIL_BLOCK_ENTITY_TYPE.value(), blockPos, blockState);
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.items);
    }

    protected void saveAdditional(CompoundTag compoundTag) {
        super.saveAdditional(compoundTag);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (boolean)true);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public int[] getSlotsForFace(Direction side) {
        int[] nArray;
        if (side != Direction.DOWN) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return false;
    }

    protected Component getDefaultName() {
        return REPAIR_COMPONENT;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new ModAnvilMenu(id, playerInventory, this, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition));
    }

    public NonNullList<ItemStack> getResult() {
        return this.result;
    }
}

