/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.util.NoAdvRecipeOutput;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class BlockRecipeGenerator
extends RecipeProvider {
    public BlockRecipeGenerator(PackOutput packOutput) {
        super(packOutput);
    }

    protected void buildRecipes(@Nonnull RecipeOutput output) {
        NoAdvRecipeOutput recipeOutput = new NoAdvRecipeOutput(output);
        Recipe.shapeless((ItemLike)ActuallyBlocks.BATTERY_BOX.getItem()).ingredients(new ItemLike[]{ActuallyBlocks.ENERGIZER.get(), ActuallyBlocks.ENERVATOR.get(), (ItemLike)ActuallyItems.BASIC_COIL.get()}).save(recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.FARMER.getItem()).pattern("ISI", "SCS", "ISI").define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.ENORI_CRYSTAL.getItem()).define(Character.valueOf('C'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).define(Character.valueOf('S'), Tags.Items.SEEDS).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.EMPOWERER.getItem()).pattern(" R ", " B ", "CDC").define(Character.valueOf('R'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).define(Character.valueOf('B'), (ItemLike)ActuallyItems.DOUBLE_BATTERY.get()).define(Character.valueOf('C'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).define(Character.valueOf('D'), (ItemLike)ActuallyBlocks.DISPLAY_STAND.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.TINY_TORCH.getItem(), 2).pattern("C", "S").define(Character.valueOf('C'), ActuallyTags.Items.TINY_COALS).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.FIREWORK_BOX.getItem()).pattern("GFG", "SAS", "CCC").define(Character.valueOf('G'), Tags.Items.GUNPOWDER).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('A'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).define(Character.valueOf('F'), (ItemLike)Items.FIREWORK_ROCKET).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.SHOCK_SUPPRESSOR.getItem()).pattern("OAO", "ACA", "OAO").define(Character.valueOf('A'), (ItemLike)ActuallyItems.EMPOWERED_VOID_CRYSTAL.get()).define(Character.valueOf('O'), Tags.Items.OBSIDIAN).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.DISPLAY_STAND.getItem()).pattern(" R ", "EEE", "GGG").define(Character.valueOf('R'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).define(Character.valueOf('E'), (ItemLike)ActuallyBlocks.ETHETIC_GREEN_BLOCK.get()).define(Character.valueOf('G'), (ItemLike)ActuallyBlocks.ETHETIC_WHITE_BLOCK.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.VERTICAL_DIGGER.getItem()).pattern("IRI", "RCR", "IDI").define(Character.valueOf('R'), Tags.Items.STORAGE_BLOCKS_REDSTONE).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.EMPOWERED_VOID_CRYSTAL.get()).define(Character.valueOf('D'), ActuallyTags.Items.DRILLS).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.PLAYER_INTERFACE.getItem()).pattern("CWC", "ECE", "CAC").define(Character.valueOf('C'), (ItemLike)ActuallyBlocks.ENDER_CASING.getItem()).define(Character.valueOf('W'), (ItemLike)Items.WITHER_SKELETON_SKULL).define(Character.valueOf('E'), ActuallyItems.EMPOWERED_DIAMATINE_CRYSTAL).define(Character.valueOf('A'), ActuallyItems.ADVANCED_COIL).save((RecipeOutput)recipeOutput);
        Recipe.wall((ItemLike)ActuallyBlocks.BLACK_QUARTZ_WALL.getItem(), (ItemLike)ActuallyBlocks.BLACK_QUARTZ_PILLAR.get(), recipeOutput);
        Recipe.slab((ItemLike)ActuallyBlocks.BLACK_QUARTZ_SLAB.getItem(), (ItemLike)ActuallyBlocks.BLACK_QUARTZ_PILLAR.get(), recipeOutput);
        Recipe.stairs((ItemLike)ActuallyBlocks.BLACK_QUARTZ_STAIR.getItem(), (ItemLike)ActuallyBlocks.BLACK_QUARTZ_PILLAR.get(), recipeOutput);
        Recipe.wall((ItemLike)ActuallyBlocks.SMOOTH_BLACK_QUARTZ_WALL.getItem(), (ItemLike)ActuallyBlocks.SMOOTH_BLACK_QUARTZ.get(), recipeOutput);
        Recipe.slab((ItemLike)ActuallyBlocks.SMOOTH_BLACK_QUARTZ_SLAB.getItem(), (ItemLike)ActuallyBlocks.SMOOTH_BLACK_QUARTZ.get(), recipeOutput);
        Recipe.stairs((ItemLike)ActuallyBlocks.SMOOTH_BLACK_QUARTZ_STAIR.getItem(), (ItemLike)ActuallyBlocks.SMOOTH_BLACK_QUARTZ.get(), recipeOutput);
        Recipe.wall((ItemLike)ActuallyBlocks.BLACK_QUARTZ_BRICK_WALL.getItem(), (ItemLike)ActuallyBlocks.BLACK_QUARTZ_BRICK.get(), recipeOutput);
        Recipe.slab((ItemLike)ActuallyBlocks.BLACK_QUARTZ_BRICK_SLAB.getItem(), (ItemLike)ActuallyBlocks.BLACK_QUARTZ_BRICK.get(), recipeOutput);
        Recipe.stairs((ItemLike)ActuallyBlocks.BLACK_QUARTZ_BRICK_STAIR.getItem(), (ItemLike)ActuallyBlocks.BLACK_QUARTZ_BRICK.get(), recipeOutput);
        Recipe.wall((ItemLike)ActuallyBlocks.BLACK_QUARTZ_PILLAR_WALL.getItem(), (ItemLike)ActuallyBlocks.BLACK_QUARTZ_PILLAR.get(), recipeOutput);
        Recipe.slab((ItemLike)ActuallyBlocks.BLACK_QUARTZ_PILLAR_SLAB.getItem(), (ItemLike)ActuallyBlocks.BLACK_QUARTZ_PILLAR.get(), recipeOutput);
        Recipe.stairs((ItemLike)ActuallyBlocks.BLACK_QUARTZ_PILLAR_STAIR.getItem(), (ItemLike)ActuallyBlocks.BLACK_QUARTZ_PILLAR.get(), recipeOutput);
        Recipe.wall((ItemLike)ActuallyBlocks.CHISELED_BLACK_QUARTZ_WALL.getItem(), (ItemLike)ActuallyBlocks.CHISELED_BLACK_QUARTZ.get(), recipeOutput);
        Recipe.slab((ItemLike)ActuallyBlocks.CHISELED_BLACK_QUARTZ_SLAB.getItem(), (ItemLike)ActuallyBlocks.CHISELED_BLACK_QUARTZ.get(), recipeOutput);
        Recipe.stairs((ItemLike)ActuallyBlocks.CHISELED_BLACK_QUARTZ_STAIR.getItem(), (ItemLike)ActuallyBlocks.CHISELED_BLACK_QUARTZ.get(), recipeOutput);
        Recipe.wall((ItemLike)ActuallyBlocks.ETHETIC_WHITE_WALL.getItem(), (ItemLike)ActuallyBlocks.ETHETIC_WHITE_BLOCK.get(), recipeOutput);
        Recipe.slab((ItemLike)ActuallyBlocks.ETHETIC_WHITE_SLAB.getItem(), (ItemLike)ActuallyBlocks.ETHETIC_WHITE_BLOCK.get(), recipeOutput);
        Recipe.stairs((ItemLike)ActuallyBlocks.ETHETIC_WHITE_STAIRS.getItem(), (ItemLike)ActuallyBlocks.ETHETIC_WHITE_BLOCK.get(), recipeOutput);
        Recipe.wall((ItemLike)ActuallyBlocks.ETHETIC_GREEN_WALL.getItem(), (ItemLike)ActuallyBlocks.ETHETIC_GREEN_BLOCK.get(), recipeOutput);
        Recipe.slab((ItemLike)ActuallyBlocks.ETHETIC_GREEN_SLAB.getItem(), (ItemLike)ActuallyBlocks.ETHETIC_GREEN_BLOCK.get(), recipeOutput);
        Recipe.stairs((ItemLike)ActuallyBlocks.ETHETIC_GREEN_STAIRS.getItem(), (ItemLike)ActuallyBlocks.ETHETIC_GREEN_BLOCK.get(), recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.ATOMIC_RECONSTRUCTOR.getItem()).pattern("IRI", "RCR", "IRI").define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('C'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.LASER_RELAY.getItem(), 4).pattern("OBO", "RCR", "OBO").define(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_REDSTONE).define(Character.valueOf('O'), Tags.Items.OBSIDIAN).define(Character.valueOf('R'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.LASER_RELAY_ADVANCED.getItem()).pattern(" I ", "XRX", " I ").define(Character.valueOf('I'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).define(Character.valueOf('R'), (ItemLike)ActuallyBlocks.LASER_RELAY.get()).define(Character.valueOf('X'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.LASER_RELAY_EXTREME.getItem()).pattern(" I ", "XRX", " I ").define(Character.valueOf('I'), (ItemLike)ActuallyItems.EMPOWERED_DIAMATINE_CRYSTAL.get()).define(Character.valueOf('R'), (ItemLike)ActuallyBlocks.LASER_RELAY_ADVANCED.get()).define(Character.valueOf('X'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyBlocks.LASER_RELAY_ITEM_ADVANCED.getItem()).ingredients(new ItemLike[]{ActuallyBlocks.LASER_RELAY_ITEM.get(), (ItemLike)ActuallyItems.ADVANCED_COIL.get(), (ItemLike)ActuallyItems.BLACK_QUARTZ.get()}).save(recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.ITEM_INTERFACE.getItem()).pattern("OBO", "RCR", "OBO").define(Character.valueOf('B'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('O'), (ItemLike)ActuallyItems.BASIC_COIL.get()).define(Character.valueOf('R'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyBlocks.ITEM_INTERFACE_HOPPING.get()).ingredients(new ItemLike[]{ActuallyBlocks.ITEM_INTERFACE.get()}).save(recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.WOOD_CASING.getItem()).pattern("WSW", "SRS", "WSW").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('R'), ItemTags.LOGS).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.IRON_CASING.getItem()).pattern("WSW", "SQS", "WSW").define(Character.valueOf('Q'), (ItemLike)ActuallyItems.BLACK_QUARTZ.get()).define(Character.valueOf('W'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.ENDER_CASING.getItem()).pattern("WSW", "SRS", "WSW").define(Character.valueOf('W'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('R'), (ItemLike)ActuallyBlocks.BLACK_QUARTZ.getItem()).define(Character.valueOf('S'), (ItemLike)ActuallyItems.EMPOWERED_DIAMATINE_CRYSTAL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.COFFEE_MACHINE.getItem()).pattern(" C ", " I ", "XVX").define(Character.valueOf('C'), (ItemLike)ActuallyItems.COFFEE_BEANS).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.IRON_CASING.getItem()).define(Character.valueOf('X'), (ItemLike)ActuallyItems.BASIC_COIL.get()).define(Character.valueOf('V'), (ItemLike)ActuallyItems.VOID_CRYSTAL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.CANOLA_PRESS.getItem()).pattern("CEC", "CXC", "CAC").define(Character.valueOf('C'), Tags.Items.COBBLESTONE).define(Character.valueOf('E'), ActuallyItems.ENORI_CRYSTAL).define(Character.valueOf('X'), ActuallyItems.CANOLA).define(Character.valueOf('A'), ActuallyItems.ADVANCED_COIL).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.FERMENTING_BARREL.getItem()).pattern("LAL", "LCL", "LWL").define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('A'), ActuallyItems.ENORI_CRYSTAL).define(Character.valueOf('C'), ActuallyItems.CANOLA).define(Character.valueOf('W'), (ItemLike)ActuallyBlocks.WOOD_CASING.getItem()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.OIL_GENERATOR.getItem()).pattern("CIC", "CAC", "CIC").define(Character.valueOf('C'), Tags.Items.COBBLESTONE).define(Character.valueOf('A'), ActuallyItems.CANOLA).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.IRON_CASING.getItem()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.COAL_GENERATOR.getItem()).pattern("CIC", "CAC", "CIC").define(Character.valueOf('C'), Tags.Items.COBBLESTONE).define(Character.valueOf('A'), (ItemLike)Items.COAL).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.IRON_CASING.getItem()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.BREAKER.getItem()).pattern("CCC", "CXV", "CCC").define(Character.valueOf('C'), Tags.Items.COBBLESTONE).define(Character.valueOf('V'), ActuallyItems.VOID_CRYSTAL).define(Character.valueOf('X'), ActuallyItems.BASIC_COIL).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.PLACER.getItem()).pattern("CCC", "CXP", "CCC").define(Character.valueOf('C'), Tags.Items.COBBLESTONE).define(Character.valueOf('P'), ActuallyItems.PALIS_CRYSTAL).define(Character.valueOf('X'), ActuallyItems.BASIC_COIL).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.DROPPER.getItem()).pattern("CPC", "CDA", "CPC").define(Character.valueOf('C'), Tags.Items.COBBLESTONE).define(Character.valueOf('P'), ActuallyItems.PALIS_CRYSTAL).define(Character.valueOf('D'), (ItemLike)Items.DROPPER).define(Character.valueOf('A'), ActuallyItems.ADVANCED_COIL).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.FLUID_PLACER.getItem()).pattern("BPB").define(Character.valueOf('B'), (ItemLike)Items.BUCKET).define(Character.valueOf('P'), (ItemLike)ActuallyBlocks.PLACER.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.FLUID_COLLECTOR.getItem()).pattern("BFB").define(Character.valueOf('B'), (ItemLike)Items.BUCKET).define(Character.valueOf('F'), (ItemLike)ActuallyBlocks.BREAKER.get()).save((RecipeOutput)recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyBlocks.PHANTOM_PLACER.get()).ingredients(new ItemLike[]{ActuallyBlocks.PLACER.get(), ActuallyBlocks.PHANTOM_ITEMFACE.get()}).save(recipeOutput);
        Recipe.shapeless((ItemLike)ActuallyBlocks.PHANTOM_BREAKER.get()).ingredients(new ItemLike[]{ActuallyBlocks.BREAKER.get(), ActuallyBlocks.PHANTOM_ITEMFACE.get()}).save(recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.POWERED_FURNACE.getItem()).pattern("EXC", "FIF", "CXE").define(Character.valueOf('E'), (ItemLike)ActuallyItems.ENORI_CRYSTAL).define(Character.valueOf('X'), ActuallyItems.BASIC_COIL).define(Character.valueOf('C'), Tags.Items.COBBLESTONE).define(Character.valueOf('F'), (ItemLike)Items.FURNACE).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.IRON_CASING.getItem()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.GREENHOUSE_GLASS.getItem(), 2).pattern("GSG", "SES", "GSG").define(Character.valueOf('G'), Tags.Items.GLASS).define(Character.valueOf('S'), ItemTags.SAPLINGS).define(Character.valueOf('E'), ActuallyItems.EMPOWERED_PALIS_CRYSTAL).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.BLACK_QUARTZ.getItem()).pattern("BB", "BB").define(Character.valueOf('B'), (ItemLike)ActuallyItems.BLACK_QUARTZ).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.BLACK_QUARTZ_PILLAR.getItem()).pattern("B", "B").define(Character.valueOf('B'), (ItemLike)ActuallyItems.BLACK_QUARTZ).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.CHISELED_BLACK_QUARTZ.getItem(), 2).pattern("B", "B").define(Character.valueOf('B'), (ItemLike)ActuallyBlocks.BLACK_QUARTZ.getItem()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.LAVA_FACTORY_CONTROLLER.getItem()).pattern("ACA", "EAE", "BBB").define(Character.valueOf('B'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('A'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).define(Character.valueOf('E'), (ItemLike)ActuallyBlocks.EMPOWERED_ENORI_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.LAVA_FACTORY_CASING.getItem(), 4).pattern("ECE").define(Character.valueOf('E'), (ItemLike)ActuallyBlocks.ENORI_CRYSTAL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.RANGED_COLLECTOR.getItem()).pattern(" V ", "EHE", " C ").define(Character.valueOf('V'), (ItemLike)ActuallyItems.VOID_CRYSTAL.get()).define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('H'), (ItemLike)Items.HOPPER).define(Character.valueOf('C'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.CRUSHER.getItem()).pattern("RFC", "BIB", "CFR").define(Character.valueOf('R'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).define(Character.valueOf('F'), (ItemLike)Items.FLINT).define(Character.valueOf('C'), Tags.Items.COBBLESTONE).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).define(Character.valueOf('B'), (ItemLike)ActuallyItems.BASIC_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.CRUSHER_DOUBLE.getItem()).pattern("SAS", "CIC", "SAS").define(Character.valueOf('S'), Tags.Items.COBBLESTONE).define(Character.valueOf('A'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).define(Character.valueOf('C'), (ItemLike)ActuallyBlocks.CRUSHER.get()).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.ENERGIZER.getItem()).pattern("R R", "AIA", "R R").define(Character.valueOf('R'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).define(Character.valueOf('A'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.ENERVATOR.getItem()).pattern(" R ", "AIA", " R ").define(Character.valueOf('R'), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get()).define(Character.valueOf('A'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.LEAF_GENERATOR.getItem()).pattern("CIC", "ELE", "CAC").define(Character.valueOf('C'), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get()).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).define(Character.valueOf('E'), (ItemLike)ActuallyBlocks.EMPOWERED_RESTONIA_CRYSTAL.get()).define(Character.valueOf('L'), ItemTags.LEAVES).define(Character.valueOf('A'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.PHANTOM_ITEMFACE.getItem()).pattern(" C ", "MEM", " A ").define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('M'), (ItemLike)Items.PHANTOM_MEMBRANE).define(Character.valueOf('E'), (ItemLike)ActuallyBlocks.ENDER_CASING.get()).define(Character.valueOf('A'), (ItemLike)ActuallyItems.ADVANCED_COIL.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.PHANTOM_LIQUIFACE.getItem()).pattern("BIB").define(Character.valueOf('B'), (ItemLike)Items.BUCKET).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.PHANTOM_ITEMFACE.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.PHANTOM_ENERGYFACE.getItem()).pattern(" R ", "RIR", " R ").define(Character.valueOf('R'), (ItemLike)ActuallyItems.EMPOWERED_RESTONIA_CRYSTAL).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.PHANTOM_ITEMFACE.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.PHANTOM_REDSTONEFACE.getItem()).pattern("DRD", "RIR", "DRD").define(Character.valueOf('D'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('R'), ActuallyItems.EMPOWERED_RESTONIA_CRYSTAL).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.PHANTOM_ITEMFACE.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.PHANTOM_BOOSTER.getItem()).pattern("RDR", "DCD", "RDR").define(Character.valueOf('D'), (ItemLike)ActuallyItems.DIAMATINE_CRYSTAL).define(Character.valueOf('R'), ActuallyItems.RESTONIA_CRYSTAL).define(Character.valueOf('C'), (ItemLike)ActuallyBlocks.ENDER_CASING.getItem()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.FEEDER.getItem()).pattern("PGP", "BCB", "PGP").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('G'), (ItemLike)Items.GOLDEN_CARROT).define(Character.valueOf('B'), ActuallyItems.BASIC_COIL).define(Character.valueOf('C'), (ItemLike)ActuallyBlocks.WOOD_CASING.getItem()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.BIOREACTOR.getItem()).pattern("EIE", "ESE", "EIE").define(Character.valueOf('E'), (ItemLike)ActuallyItems.EMPOWERED_ENORI_CRYSTAL).define(Character.valueOf('I'), (ItemLike)ActuallyBlocks.IRON_CASING.getItem()).define(Character.valueOf('S'), ItemTags.SAPLINGS).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.HEAT_COLLECTOR.getItem()).pattern("IRI", "AEA", "ICI").define(Character.valueOf('I'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('R'), (ItemLike)Items.REPEATER).define(Character.valueOf('A'), ActuallyItems.ADVANCED_COIL).define(Character.valueOf('E'), ActuallyItems.ENORI_CRYSTAL).define(Character.valueOf('C'), (ItemLike)ActuallyBlocks.IRON_CASING.get()).save((RecipeOutput)recipeOutput);
        Recipe.shaped((ItemLike)ActuallyBlocks.LONG_RANGE_BREAKER.getItem()).pattern("AAA", " V ").define(Character.valueOf('A'), (ItemLike)ActuallyBlocks.BREAKER.get()).define(Character.valueOf('V'), ActuallyItems.VOID_CRYSTAL).save((RecipeOutput)recipeOutput);
    }

    public static class Recipe {
        public static Shapeless shapeless(ItemLike result) {
            return new Shapeless(result);
        }

        public static Shapeless shapeless(ItemLike result, int count) {
            return new Shapeless(result, count);
        }

        public static Shaped shaped(ItemLike result) {
            return new Shaped(result);
        }

        public static Shaped shaped(ItemLike result, int count) {
            return new Shaped(result, count);
        }

        public static void stairs(ItemLike result, ItemLike resource, RecipeOutput consumer) {
            Recipe.shaped(result).patternSingleKey('Q', resource, "Q  ", "QQ ", "QQQ").save(consumer);
        }

        public static void wall(ItemLike result, ItemLike resource, RecipeOutput consumer) {
            Recipe.shaped(result).patternSingleKey('Q', resource, "QQQ", "QQQ").save(consumer);
        }

        public static void slab(ItemLike result, ItemLike resource, RecipeOutput consumer) {
            Recipe.shaped(result).patternSingleKey('Q', resource, "QQQ").save(consumer);
        }

        private static class Shapeless
        extends ShapelessRecipeBuilder {
            public Shapeless(ItemLike result) {
                this(result, 1);
            }

            public Shapeless(ItemLike result, int countIn) {
                super(RecipeCategory.MISC, result, countIn);
            }

            public Shapeless ingredients(ItemLike ... ingredients) {
                Arrays.asList(ingredients).forEach(arg_0 -> ((Shapeless)this).requires(arg_0));
                return this;
            }

            public void save(RecipeOutput consumer) {
                this.unlockedBy("has_book", BlockRecipeGenerator.has((ItemLike)((ItemLike)ActuallyItems.ITEM_BOOKLET.get())));
                super.save(consumer);
            }
        }

        private static class Shaped
        extends ShapedRecipeBuilder {
            public Shaped(ItemLike resultIn) {
                this(resultIn, 1);
            }

            public Shaped(ItemLike resultIn, int countIn) {
                super(RecipeCategory.MISC, resultIn, countIn);
            }

            public Shaped pattern(String line1, String line2, String line3) {
                this.pattern(line1);
                this.pattern(line2);
                this.pattern(line3);
                return this;
            }

            public Shaped pattern(String line1, String line2) {
                this.pattern(line1);
                this.pattern(line2);
                return this;
            }

            public Shaped patternSingleKey(char key, ItemLike resource, String ... lines) {
                this.define(Character.valueOf(key), resource);
                for (String line : lines) {
                    this.pattern(line);
                }
                return this;
            }

            public void save(RecipeOutput consumerIn) {
                this.unlockedBy("has_book", BlockRecipeGenerator.has((ItemLike)((ItemLike)ActuallyItems.ITEM_BOOKLET.get())));
                super.save(consumerIn);
            }
        }
    }
}

