/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import de.ellpeck.actuallyadditions.mod.crafting.CoffeeIngredientRecipe;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;

public class CoffeeIngredientGenerator
extends RecipeProvider {
    public CoffeeIngredientGenerator(PackOutput packOutput) {
        super(packOutput);
    }

    public String getName() {
        return "Coffee Ingredient " + super.getName();
    }

    protected void buildRecipes(@Nonnull RecipeOutput recipeOutput) {
        this.buildIngredient(recipeOutput, (ItemLike)Items.MILK_BUCKET, 0, "jei.actuallyadditions.coffee.extra.milk", new MobEffectInstance[0]);
        TagKey milkTag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "milk"));
        RecipeOutput tagOutput = recipeOutput.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(milkTag.location()))});
        this.buildIngredient(tagOutput, new ResourceLocation("actuallyadditions", "coffee_ingredient/milk_tagged"), Ingredient.of((TagKey)milkTag), 0, "jei.actuallyadditions.coffee.extra.milk", new MobEffectInstance[0]);
        this.buildIngredient(recipeOutput, (ItemLike)Items.SUGAR, 4, new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 30, 0));
        this.buildIngredient(recipeOutput, (ItemLike)Items.MAGMA_CREAM, 2, new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 20, 0));
        this.buildIngredient(recipeOutput, (ItemLike)Items.PUFFERFISH, 2, new MobEffectInstance(MobEffects.WATER_BREATHING, 10, 0));
        this.buildIngredient(recipeOutput, (ItemLike)Items.GOLDEN_CARROT, 2, new MobEffectInstance(MobEffects.NIGHT_VISION, 30, 0));
        this.buildIngredient(recipeOutput, (ItemLike)Items.GHAST_TEAR, 3, new MobEffectInstance(MobEffects.REGENERATION, 5, 0));
        this.buildIngredient(recipeOutput, (ItemLike)Items.BLAZE_POWDER, 4, new MobEffectInstance(MobEffects.DAMAGE_BOOST, 15, 0));
        this.buildIngredient(recipeOutput, (ItemLike)Items.FERMENTED_SPIDER_EYE, 2, new MobEffectInstance(MobEffects.INVISIBILITY, 25, 0));
    }

    private void buildIngredient(RecipeOutput recipeOutput, ItemLike ingredient, int maxAmplifier, MobEffectInstance ... effects) {
        this.buildIngredient(recipeOutput, ingredient, maxAmplifier, "", effects);
    }

    private void buildIngredient(RecipeOutput recipeOutput, ItemLike ingredient, int maxAmplifier, String extraText, MobEffectInstance ... effects) {
        ResourceLocation id = new ResourceLocation("actuallyadditions", "coffee_ingredient/" + CoffeeIngredientGenerator.getItemName((ItemLike)ingredient));
        NonNullList instances = NonNullList.create();
        for (MobEffectInstance effect : effects) {
            instances.add((Object)new CoffeeIngredientRecipe.EffectInstance(effect));
        }
        CoffeeIngredientRecipe recipe = new CoffeeIngredientRecipe(Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), (NonNullList<CoffeeIngredientRecipe.EffectInstance>)instances, maxAmplifier, extraText);
        recipeOutput.accept(id, (Recipe)recipe, null);
    }

    private void buildIngredient(RecipeOutput recipeOutput, ResourceLocation id, Ingredient ingredient, int maxAmplifier, MobEffectInstance ... effects) {
        this.buildIngredient(recipeOutput, id, ingredient, maxAmplifier, "", effects);
    }

    private void buildIngredient(RecipeOutput recipeOutput, ResourceLocation id, Ingredient ingredient, int maxAmplifier, String extraText, MobEffectInstance ... effects) {
        NonNullList instances = NonNullList.create();
        for (MobEffectInstance effect : effects) {
            instances.add((Object)new CoffeeIngredientRecipe.EffectInstance(effect));
        }
        CoffeeIngredientRecipe recipe = new CoffeeIngredientRecipe(ingredient, (NonNullList<CoffeeIngredientRecipe.EffectInstance>)instances, maxAmplifier, extraText);
        recipeOutput.accept(id, (Recipe)recipe, null);
    }
}

