/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.CrushingRecipe;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.util.NoAdvRecipeOutput;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class CrushingRecipeGenerator
extends RecipeProvider {
    public CrushingRecipeGenerator(PackOutput packOutput) {
        super(packOutput);
    }

    public String getName() {
        return "Crushing " + super.getName();
    }

    protected void buildRecipes(@Nonnull RecipeOutput output) {
        NoAdvRecipeOutput recipeOutput = new NoAdvRecipeOutput(output);
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.BONE_MEAL, 6), 1.0f)).save((RecipeOutput)recipeOutput, "bone");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR_CANE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.SUGAR, 3), 1.0f)).save((RecipeOutput)recipeOutput, "sugar_cane");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAZE_ROD}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.BLAZE_POWDER, 3), 1.0f)).save((RecipeOutput)recipeOutput, "blaze_rod");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DANDELION}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.YELLOW_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "danedlion");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.POPPY}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RED_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "poppy");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.BLUE_ORCHID}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.LIGHT_BLUE_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "blue_orchid");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.ALLIUM}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.MAGENTA_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "allium");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.AZURE_BLUET}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.LIGHT_GRAY_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "azure_bluet");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_TULIP}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RED_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "red_tulip");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.ORANGE_TULIP}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.ORANGE_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "orange_tulip");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.WHITE_TULIP}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.LIGHT_GRAY_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "white_tulip");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.PINK_TULIP}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.PINK_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "pink_tulip");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.PINK_PETALS}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.PINK_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "pink_petals");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.OXEYE_DAISY}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.LIGHT_GRAY_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "oxeye_daisy");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.CORNFLOWER}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.BLUE_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "cornflower");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.LILY_OF_THE_VALLEY}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.WHITE_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "lily_of_the_valley");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.WITHER_ROSE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.BLACK_DYE, 3), 1.0f)).save((RecipeOutput)recipeOutput, "wither_rose");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.SUNFLOWER}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.YELLOW_DYE, 4), 1.0f)).save((RecipeOutput)recipeOutput, "sunflower");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.LILAC}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.MAGENTA_DYE, 4), 1.0f)).save((RecipeOutput)recipeOutput, "lilac");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.ROSE_BUSH}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RED_DYE, 4), 1.0f)).save((RecipeOutput)recipeOutput, "rose_bush");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.PEONY}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.PINK_DYE, 4), 1.0f)).save((RecipeOutput)recipeOutput, "peony");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.PITCHER_PLANT}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.CYAN_DYE, 4), 1.0f)).save((RecipeOutput)recipeOutput, "pitcher_plant");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.REDSTONE, 10), 1.0f)).save((RecipeOutput)recipeOutput, "redstone_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DEEPSLATE_REDSTONE_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.REDSTONE, 10), 1.0f)).save((RecipeOutput)recipeOutput, "deepslate_redstone_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.LAPIS_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.LAPIS_LAZULI, 12), 1.0f)).save((RecipeOutput)recipeOutput, "lapis_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DEEPSLATE_LAPIS_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.LAPIS_LAZULI, 12), 1.0f)).save((RecipeOutput)recipeOutput, "deepslate_lapis_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.COAL, 3), 1.0f)).save((RecipeOutput)recipeOutput, "coal_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DEEPSLATE_COAL_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.COAL, 3), 1.0f)).save((RecipeOutput)recipeOutput, "deepslate_coal_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL_BLOCK}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.COAL, 9), 1.0f)).save((RecipeOutput)recipeOutput, "coal_block");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_QUARTZ_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.QUARTZ, 3), 1.0f)).save((RecipeOutput)recipeOutput, "nether_quartz_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.COBBLESTONE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.SAND, 1), 1.0f)).save((RecipeOutput)recipeOutput, "cobblestone");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.GRAVEL}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.FLINT, 1), 1.0f)).addResult2(new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.FLINT, 1), 0.5f)).save((RecipeOutput)recipeOutput, "gravel");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{ActuallyItems.RICE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.SUGAR, 2), 1.0f)).save((RecipeOutput)recipeOutput, "rice");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.GLOWSTONE_DUST, 4), 1.0f)).save((RecipeOutput)recipeOutput, "glowstone");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.DIAMOND, 2), 1.0f)).save((RecipeOutput)recipeOutput, "diamond_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DEEPSLATE_DIAMOND_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.DIAMOND, 2), 1.0f)).save((RecipeOutput)recipeOutput, "deepslate_diamond_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.EMERALD_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.EMERALD, 2), 1.0f)).save((RecipeOutput)recipeOutput, "emerald_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DEEPSLATE_EMERALD_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.EMERALD, 2), 1.0f)).save((RecipeOutput)recipeOutput, "deepslate_emerald_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_SHARD}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.PRISMARINE_CRYSTALS, 1), 1.0f)).save((RecipeOutput)recipeOutput, "prismarine_shard");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{ActuallyBlocks.BLACK_QUARTZ_ORE.get()}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)ActuallyItems.BLACK_QUARTZ.get(), 2), 1.0f)).save((RecipeOutput)recipeOutput, "black_quartz_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RAW_COPPER, 2), 1.0f)).addResult2(new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RAW_GOLD, 1), 0.05f)).save((RecipeOutput)recipeOutput, "copper_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DEEPSLATE_COPPER_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RAW_COPPER, 2), 1.0f)).addResult2(new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RAW_GOLD, 1), 0.05f)).save((RecipeOutput)recipeOutput, "deepslate_copper_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RAW_IRON, 2), 1.0f)).addResult2(new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RAW_GOLD, 1), 0.2f)).save((RecipeOutput)recipeOutput, "iron_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DEEPSLATE_IRON_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RAW_IRON, 2), 1.0f)).addResult2(new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RAW_GOLD, 1), 0.2f)).save((RecipeOutput)recipeOutput, "deepslate_iron_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_HORSE_ARMOR}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RAW_IRON, 6), 1.0f)).save((RecipeOutput)recipeOutput, "iron_horse_armor");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_HORSE_ARMOR}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RAW_GOLD, 6), 1.0f)).save((RecipeOutput)recipeOutput, "golden_horse_armor");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND_HORSE_ARMOR}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.DIAMOND, 6), 1.0f)).save((RecipeOutput)recipeOutput, "diamond_horse_armor");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RAW_GOLD, 2), 1.0f)).save((RecipeOutput)recipeOutput, "gold_ore");
        new CrushingBuilder(Ingredient.of((ItemLike[])new ItemLike[]{Items.DEEPSLATE_GOLD_ORE}), new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)Items.RAW_GOLD, 2), 1.0f)).save((RecipeOutput)recipeOutput, "deepslate_gold_ore");
    }

    public static class CrushingBuilder {
        private final Ingredient ingredient;
        private final NonNullList<CrushingRecipe.CrushingResult> results = NonNullList.withSize((int)2, (Object)CrushingRecipe.CrushingResult.EMPTY);

        public CrushingBuilder(Ingredient ingredient, CrushingRecipe.CrushingResult result) {
            this.ingredient = ingredient;
            this.results.set(0, (Object)result);
        }

        public CrushingBuilder addResult2(CrushingRecipe.CrushingResult result) {
            this.results.set(1, (Object)result);
            return this;
        }

        public void save(RecipeOutput consumer, ResourceLocation name) {
            if (this.results.size() != 2) {
                throw new IllegalStateException("invalid result count: " + this.results.size() + ", recipe: " + name.toString());
            }
            CrushingRecipe recipe = new CrushingRecipe(this.ingredient, this.results);
            consumer.accept(name, (Recipe)recipe, null);
        }

        public void save(RecipeOutput consumer, String name) {
            ResourceLocation res = new ResourceLocation("actuallyadditions", "crushing/" + name);
            if (this.results.size() != 2) {
                throw new IllegalStateException("invalid result count: " + this.results.size() + ", recipe: " + name.toString());
            }
            CrushingRecipe recipe = new CrushingRecipe(this.ingredient, this.results);
            consumer.accept(res, (Recipe)recipe, null);
        }
    }
}

