/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.EmpowererRecipe;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.Crystals;
import de.ellpeck.actuallyadditions.mod.util.NoAdvRecipeOutput;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class EmpoweringRecipeGenerator
extends RecipeProvider {
    public EmpoweringRecipeGenerator(PackOutput packOutput) {
        super(packOutput);
    }

    public String getName() {
        return "Empowering " + super.getName();
    }

    protected void buildRecipes(RecipeOutput output) {
        NoAdvRecipeOutput recipeOutput = new NoAdvRecipeOutput(output);
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_RESTONIA_CRYSTAL.get(), (ItemLike)ActuallyItems.RESTONIA_CRYSTAL.get(), 5000, 50, Crystals.REDSTONE.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_RED).addModifier((ItemLike)Items.NETHER_BRICK).addModifier((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).addModifier((ItemLike)Items.BRICK).save((RecipeOutput)recipeOutput, "restonia");
        EmpoweringBuilder.builder((ItemLike)ActuallyBlocks.EMPOWERED_RESTONIA_CRYSTAL.get(), (ItemLike)ActuallyBlocks.RESTONIA_CRYSTAL.get(), 50000, 500, Crystals.REDSTONE.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_RED).addModifier((ItemLike)Items.NETHER_BRICK).addModifier((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).addModifier((ItemLike)Items.BRICK).save((RecipeOutput)recipeOutput, "restonia_block");
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_PALIS_CRYSTAL.get(), (ItemLike)ActuallyItems.PALIS_CRYSTAL.get(), 5000, 50, Crystals.LAPIS.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_CYAN).addModifier((ItemLike)Items.PRISMARINE_SHARD).addModifier((ItemLike)Items.PRISMARINE_SHARD).addModifier((ItemLike)Items.PRISMARINE_SHARD).save((RecipeOutput)recipeOutput, "palis");
        EmpoweringBuilder.builder((ItemLike)ActuallyBlocks.EMPOWERED_PALIS_CRYSTAL.get(), (ItemLike)ActuallyBlocks.PALIS_CRYSTAL.get(), 50000, 500, Crystals.LAPIS.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_CYAN).addModifier((ItemLike)Items.PRISMARINE_SHARD).addModifier((ItemLike)Items.PRISMARINE_SHARD).addModifier((ItemLike)Items.PRISMARINE_SHARD).save((RecipeOutput)recipeOutput, "palis_block");
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_DIAMATINE_CRYSTAL.get(), (ItemLike)ActuallyItems.DIAMATINE_CRYSTAL.get(), 5000, 50, Crystals.DIAMOND.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE).addModifier((ItemLike)Items.CLAY_BALL).addModifier((ItemLike)Items.CLAY_BALL).addModifier((ItemLike)Items.CLAY).save((RecipeOutput)recipeOutput, "diamatine");
        EmpoweringBuilder.builder((ItemLike)ActuallyBlocks.EMPOWERED_DIAMATINE_CRYSTAL.get(), (ItemLike)ActuallyBlocks.DIAMATINE_CRYSTAL.get(), 50000, 500, Crystals.DIAMOND.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE).addModifier((ItemLike)Items.CLAY_BALL).addModifier((ItemLike)Items.CLAY_BALL).addModifier((ItemLike)Items.CLAY).save((RecipeOutput)recipeOutput, "diamatine_block");
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_ENORI_CRYSTAL.get(), (ItemLike)ActuallyItems.ENORI_CRYSTAL.get(), 5000, 50, Crystals.IRON.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_GRAY).addModifier((ItemLike)Items.SNOWBALL).addModifier((ItemLike)Items.STONE_BUTTON).addModifier((TagKey<Item>)Tags.Items.COBBLESTONE).save((RecipeOutput)recipeOutput, "enori");
        EmpoweringBuilder.builder((ItemLike)ActuallyBlocks.EMPOWERED_ENORI_CRYSTAL.get(), (ItemLike)ActuallyBlocks.ENORI_CRYSTAL.get(), 50000, 500, Crystals.IRON.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_GRAY).addModifier((ItemLike)Items.SNOWBALL).addModifier((ItemLike)Items.STONE_BUTTON).addModifier((TagKey<Item>)Tags.Items.COBBLESTONE).save((RecipeOutput)recipeOutput, "enori_block");
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_VOID_CRYSTAL.get(), (ItemLike)ActuallyItems.VOID_CRYSTAL.get(), 5000, 50, Crystals.COAL.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_BLACK).addModifier((TagKey<Item>)ItemTags.COALS).addModifier((ItemLike)Items.FLINT).addModifier((TagKey<Item>)Tags.Items.STONE).save((RecipeOutput)recipeOutput, "void");
        EmpoweringBuilder.builder((ItemLike)ActuallyBlocks.EMPOWERED_VOID_CRYSTAL.get(), (ItemLike)ActuallyBlocks.VOID_CRYSTAL.get(), 50000, 500, Crystals.COAL.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_BLACK).addModifier((TagKey<Item>)ItemTags.COALS).addModifier((ItemLike)Items.FLINT).addModifier((TagKey<Item>)Tags.Items.STONE).save((RecipeOutput)recipeOutput, "void_block");
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_EMERADIC_CRYSTAL.get(), (ItemLike)ActuallyItems.EMERADIC_CRYSTAL.get(), 5000, 50, Crystals.EMERALD.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_LIME).addModifier((ItemLike)Items.TALL_GRASS).addModifier((TagKey<Item>)ItemTags.SAPLINGS).addModifier((TagKey<Item>)Tags.Items.SLIMEBALLS).save((RecipeOutput)recipeOutput, "emeradic");
        EmpoweringBuilder.builder((ItemLike)ActuallyBlocks.EMPOWERED_EMERADIC_CRYSTAL.get(), (ItemLike)ActuallyBlocks.EMERADIC_CRYSTAL.get(), 50000, 500, Crystals.EMERALD.conversionColorParticles).addModifier((TagKey<Item>)Tags.Items.DYES_LIME).addModifier((ItemLike)Items.TALL_GRASS).addModifier((TagKey<Item>)ItemTags.SAPLINGS).addModifier((TagKey<Item>)Tags.Items.SLIMEBALLS).save((RecipeOutput)recipeOutput, "emeradic_block");
        EmpoweringBuilder.builder((ItemLike)ActuallyItems.EMPOWERED_CANOLA_SEED.get(), (ItemLike)ActuallyItems.CRYSTALLIZED_CANOLA_SEED.get(), 1000, 30, 16735052).addModifier((ItemLike)ActuallyItems.CANOLA_SEEDS.get()).addModifier((ItemLike)ActuallyItems.CANOLA_SEEDS.get()).addModifier((ItemLike)ActuallyItems.CANOLA_SEEDS.get()).addModifier((ItemLike)ActuallyItems.CANOLA_SEEDS.get()).save((RecipeOutput)recipeOutput, "empowered_canola");
    }

    public static class EmpoweringBuilder {
        private final Item result;
        private final Ingredient base;
        private final int energy;
        private final int time;
        private final int color;
        private final NonNullList<Ingredient> modifiers = NonNullList.create();

        public EmpoweringBuilder(ItemLike resultIn, Ingredient baseIn, int energyIn, int timeIn, int colorIn) {
            this.result = resultIn.asItem();
            this.base = baseIn;
            this.energy = energyIn;
            this.time = timeIn;
            this.color = colorIn;
        }

        public static EmpoweringBuilder builder(ItemLike resultIn, ItemLike base, int energyIn, int timeIn, int colorIn) {
            return new EmpoweringBuilder(resultIn, Ingredient.of((ItemLike[])new ItemLike[]{base}), energyIn, timeIn, colorIn);
        }

        public EmpoweringBuilder addModifier(ItemLike input) {
            if (this.modifiers.size() >= 4) {
                throw new IllegalStateException("too many modifiers for empowering recipe, input: " + BuiltInRegistries.ITEM.getKey((Object)input.asItem()));
            }
            this.modifiers.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{input}));
            return this;
        }

        public EmpoweringBuilder addModifier(ItemStack input) {
            if (this.modifiers.size() >= 4) {
                throw new IllegalStateException("too many modifiers for empowering recipe, input: " + BuiltInRegistries.ITEM.getKey((Object)input.getItem()));
            }
            this.modifiers.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{input}));
            return this;
        }

        public EmpoweringBuilder addModifier(TagKey<Item> input) {
            if (this.modifiers.size() >= 4) {
                throw new IllegalStateException("too many modifiers for empowering recipe, input: " + input.toString());
            }
            this.modifiers.add((Object)Ingredient.of(input));
            return this;
        }

        public void save(RecipeOutput consumer, ResourceLocation name) {
            if (this.modifiers.size() != 4) {
                throw new IllegalStateException("invalid modifier count: " + this.modifiers.size() + ", recipe: " + name.toString());
            }
            EmpowererRecipe recipe = new EmpowererRecipe(this.result.getDefaultInstance(), this.base, this.modifiers, this.energy, this.color, this.time);
            consumer.accept(name, (Recipe)recipe, null);
        }

        public void save(RecipeOutput consumer, String name) {
            ResourceLocation res = new ResourceLocation("actuallyadditions", "empowering/" + name);
            if (this.modifiers.size() != 4) {
                throw new IllegalStateException("invalid modifier count: " + this.modifiers.size() + ", recipe: " + res);
            }
            EmpowererRecipe recipe = new EmpowererRecipe(this.result.getDefaultInstance(), this.base, this.modifiers, this.energy, this.color, this.time);
            consumer.accept(res, (Recipe)recipe, null);
        }
    }
}

