/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.crafting.LiquidFuelRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.SolidFuelRecipe;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.util.NoAdvRecipeOutput;
import javax.annotation.Nonnull;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class FuelRecipeGenerator
extends RecipeProvider {
    public FuelRecipeGenerator(PackOutput packOutput) {
        super(packOutput);
    }

    public String getName() {
        return "Fuel " + super.getName();
    }

    protected void buildRecipes(@Nonnull RecipeOutput output) {
        NoAdvRecipeOutput recipeOutput = new NoAdvRecipeOutput(output);
        this.addSolid((RecipeOutput)recipeOutput, "coal", Items.COAL, 32000, 1600);
        this.addSolid((RecipeOutput)recipeOutput, "stick", Items.STICK, 2000, 100);
        this.addSolid((RecipeOutput)recipeOutput, "tiny-coal", ActuallyTags.Items.TINY_COALS, 4000, 200);
        this.addSolid((RecipeOutput)recipeOutput, "charcoal", Items.CHARCOAL, 32000, 1600);
        this.addSolid((RecipeOutput)recipeOutput, "coal-block", Items.COAL_BLOCK, 320000, 16000);
        this.addSolid((RecipeOutput)recipeOutput, "lava", Items.LAVA_BUCKET, 400000, 20000);
        recipeOutput.accept(new ResourceLocation("actuallyadditions", "liquid_fuel/canola_oil"), new LiquidFuelRecipe(new FluidStack(InitFluids.CANOLA_OIL.get(), 50), 4000, 100), null);
        recipeOutput.accept(new ResourceLocation("actuallyadditions", "liquid_fuel/refined_canola_oil"), new LiquidFuelRecipe(new FluidStack(InitFluids.REFINED_CANOLA_OIL.get(), 50), 9600, 120), null);
        recipeOutput.accept(new ResourceLocation("actuallyadditions", "liquid_fuel/crystallized_canola_oil"), new LiquidFuelRecipe(new FluidStack(InitFluids.CRYSTALLIZED_OIL.get(), 50), 28000, 280), null);
        recipeOutput.accept(new ResourceLocation("actuallyadditions", "liquid_fuel/empowered_canola_oil"), new LiquidFuelRecipe(new FluidStack(InitFluids.EMPOWERED_OIL.get(), 50), 48000, 400), null);
    }

    private void addSolid(RecipeOutput consumer, String name, Item item, int energy, int burnTime) {
        ResourceLocation id = new ResourceLocation("actuallyadditions", "solid_fuel/" + name);
        consumer.accept(id, (Recipe)new SolidFuelRecipe(Ingredient.of((ItemLike[])new ItemLike[]{item}), energy, burnTime), null);
    }

    private void addSolid(RecipeOutput consumer, String name, Ingredient item, int energy, int burnTime) {
        ResourceLocation id = new ResourceLocation("actuallyadditions", "solid_fuel/" + name);
        consumer.accept(id, (Recipe)new SolidFuelRecipe(item, energy, burnTime), null);
    }

    private void addSolid(RecipeOutput consumer, String name, TagKey<Item> tag, int energy, int burnTime) {
        ResourceLocation id = new ResourceLocation("actuallyadditions", "solid_fuel/" + name);
        consumer.accept(id, (Recipe)new SolidFuelRecipe(Ingredient.of(tag), energy, burnTime), null);
    }
}

