/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.mod.AASounds;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditionsClient;
import de.ellpeck.actuallyadditions.mod.ActuallyTabs;
import de.ellpeck.actuallyadditions.mod.ClientRegistryHandler;
import de.ellpeck.actuallyadditions.mod.attachments.ActuallyAttachments;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.config.conditions.BoolConfigCondition;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.CrusherCrafting;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.entity.EntityWorm;
import de.ellpeck.actuallyadditions.mod.entity.InitEntities;
import de.ellpeck.actuallyadditions.mod.event.CommonEvents;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.gen.ActuallyVillages;
import de.ellpeck.actuallyadditions.mod.gen.modifier.BoolConfigFeatureBiomeModifier;
import de.ellpeck.actuallyadditions.mod.gen.village.ActuallyPOITypes;
import de.ellpeck.actuallyadditions.mod.gen.village.ActuallyVillagers;
import de.ellpeck.actuallyadditions.mod.gen.village.InitVillager;
import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.Worm;
import de.ellpeck.actuallyadditions.mod.lootmodifier.ActuallyLootModifiers;
import de.ellpeck.actuallyadditions.mod.misc.BannerHelper;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.LaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.MethodHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.particle.ActuallyParticles;
import de.ellpeck.actuallyadditions.mod.update.UpdateChecker;
import de.ellpeck.actuallyadditions.mod.util.ResourceReloader;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="actuallyadditions")
public class ActuallyAdditions {
    public static final String MODID = "actuallyadditions";
    @Deprecated
    public static final String NAME = "Actually Additions";
    @Deprecated
    public static final String VERSION = "@VERSION@";
    @Deprecated
    public static final String GUIFACTORY = "de.ellpeck.actuallyadditions.mod.config.GuiFactory";
    public static final String DEPS = "required:forge@[14.23.5.2836,);before:craftingtweaks;after:fastbench@[1.3.2,)";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"actuallyadditions");
    private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"actuallyadditions");
    public static final Supplier<EntityType<EntityWorm>> ENTITY_WORM = ENTITIES.register("worm", () -> EntityType.Builder.of(EntityWorm::new, (MobCategory)MobCategory.MISC).build("actuallyadditions:worm"));
    private static final DeferredRegister<Codec<? extends ICondition>> CONDITION_CODECS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (String)"actuallyadditions");
    public static final DeferredHolder<Codec<? extends ICondition>, Codec<BoolConfigCondition>> BOOL_CONFIG_CONDITION = CONDITION_CODECS.register("bool_config_condition", () -> BoolConfigCondition.CODEC);
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"actuallyadditions");
    public static final Supplier<Codec<BoolConfigFeatureBiomeModifier>> BOOL_CONFIG_MODIFIER = BIOME_MODIFIER_SERIALIZERS.register("bool_config_feature_modifier", () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(BoolConfigFeatureBiomeModifier::biomes), (App)PlacedFeature.LIST_CODEC.fieldOf("features").forGetter(BoolConfigFeatureBiomeModifier::features), (App)GenerationStep.Decoration.CODEC.fieldOf("step").forGetter(BoolConfigFeatureBiomeModifier::step), (App)Codec.STRING.fieldOf("boolConfig").forGetter(BoolConfigFeatureBiomeModifier::boolConfig)).apply((Applicative)builder, BoolConfigFeatureBiomeModifier::new)));
    public static boolean commonCapsLoaded;

    public ActuallyAdditions(IEventBus eventBus) {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_CONFIG);
        ActuallyBlocks.init(eventBus);
        ActuallyItems.init(eventBus);
        ActuallyTabs.init(eventBus);
        ActuallyRecipes.init(eventBus);
        AASounds.init(eventBus);
        ActuallyVillagers.init(eventBus);
        ActuallyPOITypes.init(eventBus);
        ActuallyAttachments.init(eventBus);
        ActuallyLootModifiers.init(eventBus);
        BannerHelper.init(eventBus);
        ActuallyContainers.CONTAINERS.register(eventBus);
        ENTITIES.register(eventBus);
        CONDITION_CODECS.register(eventBus);
        BIOME_MODIFIER_SERIALIZERS.register(eventBus);
        eventBus.addListener(this::onConfigReload);
        ActuallyParticles.init(eventBus);
        ActuallyTags.init();
        NeoForge.EVENT_BUS.addListener(this::serverStarted);
        NeoForge.EVENT_BUS.addListener(this::serverStopped);
        NeoForge.EVENT_BUS.addListener(InitVillager::setupTrades);
        NeoForge.EVENT_BUS.register((Object)new CommonEvents());
        NeoForge.EVENT_BUS.addListener(ActuallyAdditions::reloadEvent);
        NeoForge.EVENT_BUS.addListener(Worm::onHoe);
        NeoForge.EVENT_BUS.addListener(ActuallyVillages::modifyVillageStructures);
        InitFluids.init(eventBus);
        eventBus.addListener(PacketHandler::register);
        eventBus.addListener(this::setup);
        if (FMLEnvironment.dist.isClient()) {
            eventBus.addListener(ActuallyAdditionsClient::setup);
            eventBus.addListener(ActuallyAdditionsClient::setupMenus);
            eventBus.addListener(ActuallyAdditionsClient::setupSpecialRenders);
            eventBus.addListener(ActuallyAdditionsClient::registerParticleFactories);
            eventBus.register((Object)new ClientRegistryHandler());
        }
        IFarmerBehavior.initBehaviors();
    }

    private static void reloadEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ResourceReloader(event.getServerResources()));
    }

    private void setup(FMLCommonSetupEvent event) {
        ActuallyAdditionsAPI.methodHandler = new MethodHandler();
        ActuallyAdditionsAPI.connectionHandler = new LaserRelayConnectionHandler();
        commonCapsLoaded = false;
        new UpdateChecker();
        InitEntities.init();
        CrusherCrafting.init();
    }

    private void onConfigReload(ModConfigEvent event) {
        Item item1 = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation((String)CommonConfig.Other.REDSTONECONFIGURATOR.get()));
        Item item2 = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation((String)CommonConfig.Other.RELAYCONFIGURATOR.get()));
        CommonConfig.Other.redstoneConfigureItem = item1 != null ? item1 : Items.AIR;
        CommonConfig.Other.relayConfigureItem = item2 != null ? item2 : Items.AIR;
    }

    public void serverStarted(ServerStartedEvent event) {
    }

    public void serverStopped(ServerStoppedEvent event) {
        WorldData.clear();
    }
}

