/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.attachments;

import de.ellpeck.actuallyadditions.mod.attachments.ItemTagAttachment;
import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ActuallyAttachments {
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"actuallyadditions");
    public static final Supplier<AttachmentType<CustomEnergyStorage>> ENERGY_STORAGE = ATTACHMENT_TYPES.register("energy", ActuallyAttachments.itemEnergyStorageAttachment());
    public static final Supplier<AttachmentType<ItemTagAttachment>> ITEM_TAG = ATTACHMENT_TYPES.register("item_tag", () -> AttachmentType.serializable(ItemTagAttachment::new).build());

    public static Supplier<AttachmentType<CustomEnergyStorage>> itemEnergyStorageAttachment() {
        return () -> AttachmentType.serializable(holder -> {
            if (holder instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)holder;
                int capacity = 1000;
                int maxTransfer = 1000;
                Item patt1734$temp = itemStack.getItem();
                if (patt1734$temp instanceof ItemEnergy) {
                    ItemEnergy itemEnergy = (ItemEnergy)patt1734$temp;
                    capacity = itemEnergy.maxPower;
                    maxTransfer = itemEnergy.transfer;
                }
                return new CustomEnergyStorage(capacity, maxTransfer, maxTransfer);
            }
            throw new IllegalStateException("Cannot attach energy handler item to a non-item.");
        }).build();
    }

    public static void init(IEventBus evt) {
        ATTACHMENT_TYPES.register(evt);
    }
}

