/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.VoxelShapes;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDisplayStand;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEmpowerer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockDisplayStand
extends BlockContainerBase {
    private final boolean isEmpowerer;

    public BlockDisplayStand(boolean empowerer) {
        super(ActuallyBlocks.defaultPickProps());
        this.isEmpowerer = empowerer;
    }

    public boolean isEmpowerer() {
        return this.isEmpowerer;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.isEmpowerer ? new TileEntityEmpowerer(pos, state) : new TileEntityDisplayStand(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return this.isEmpowerer ? (level.isClientSide ? TileEntityEmpowerer::clientTick : TileEntityEmpowerer::serverTick) : (level.isClientSide ? TileEntityDisplayStand::clientTick : TileEntityDisplayStand::serverTick);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!world.isClientSide) {
            TileEntityInventoryBase stand = (TileEntityInventoryBase)world.getBlockEntity(pos);
            if (stand != null) {
                ItemStack stackThere = stand.inv.getStackInSlot(0);
                if (!heldItem.isEmpty()) {
                    int maxTransfer;
                    if (stackThere.isEmpty() && (!this.isEmpowerer || TileEntityEmpowerer.isPossibleInput(heldItem))) {
                        ItemStack toPut = heldItem.copy();
                        toPut.setCount(1);
                        stand.inv.setStackInSlot(0, toPut);
                        if (!player.isCreative()) {
                            heldItem.shrink(1);
                        } else {
                            player.swing(hand, true);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (ItemUtil.canBeStacked(heldItem, stackThere) && (maxTransfer = Math.min(stackThere.getCount(), heldItem.getMaxStackSize() - heldItem.getCount())) > 0) {
                        if (!player.isCreative()) {
                            player.setItemInHand(hand, StackUtil.grow(heldItem, maxTransfer));
                        } else {
                            player.swing(hand, true);
                        }
                        ItemStack newStackThere = stackThere.copy();
                        newStackThere.shrink(maxTransfer);
                        stand.inv.setStackInSlot(0, newStackThere);
                        return InteractionResult.SUCCESS;
                    }
                } else if (!stackThere.isEmpty() && hand == InteractionHand.MAIN_HAND) {
                    player.setItemInHand(hand, stackThere.copy());
                    stand.inv.setStackInSlot(0, ItemStack.EMPTY);
                    return InteractionResult.CONSUME;
                }
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return VoxelShapes.SIMPLE_STAND_SHAPE;
    }
}

