/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEnergizer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEnervator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockEnergizer
extends BlockContainerBase {
    private final boolean isEnergizer;

    public BlockEnergizer(boolean isEnergizer) {
        super(ActuallyBlocks.defaultPickProps(2.0f, 10.0f));
        this.isEnergizer = isEnergizer;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.isEnergizer ? new TileEntityEnergizer(pos, state) : new TileEntityEnervator(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return this.isEnergizer ? (level.isClientSide ? TileEntityEnergizer::clientTick : TileEntityEnergizer::serverTick) : (level.isClientSide ? TileEntityEnervator::clientTick : TileEntityEnervator::serverTick);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.isEnergizer) {
            return this.openGui(world, player, pos, TileEntityEnergizer.class);
        }
        return this.openGui(world, player, pos, TileEntityEnervator.class);
    }
}

