/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import com.mojang.blaze3d.platform.Window;
import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomBreaker;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomEnergyface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomItemface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomLiquiface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomPlacer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomRedstoneface;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockPhantom
extends BlockContainerBase
implements IHudDisplay {
    public final Type type;

    public BlockPhantom(Type type) {
        super(ActuallyBlocks.defaultPickProps(4.5f, 10.0f));
        this.type = type;
    }

    public boolean isSignalSource(BlockState state) {
        return this.type == Type.REDSTONEFACE;
    }

    public int getSignal(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tile;
        if (this.type == Type.REDSTONEFACE && (tile = world.getBlockEntity(pos)) instanceof TileEntityPhantomRedstoneface) {
            return ((TileEntityPhantomRedstoneface)tile).providesWeak[side.ordinal()];
        }
        return 0;
    }

    public int getDirectSignal(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tile;
        if (this.type == Type.REDSTONEFACE && (tile = world.getBlockEntity(pos)) instanceof TileEntityPhantomRedstoneface) {
            return ((TileEntityPhantomRedstoneface)tile).providesStrong[side.ordinal()];
        }
        return 0;
    }

    @Override
    public boolean shouldDropInventory(Level world, BlockPos pos) {
        return this.type == Type.PLACER || this.type == Type.BREAKER;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        switch (this.type) {
            case PLACER: {
                return new TileEntityPhantomPlacer(pos, state);
            }
            case BREAKER: {
                return new TileEntityPhantomBreaker(pos, state);
            }
            case LIQUIFACE: {
                return new TileEntityPhantomLiquiface(pos, state);
            }
            case ENERGYFACE: {
                return new TileEntityPhantomEnergyface(pos, state);
            }
            case REDSTONEFACE: {
                return new TileEntityPhantomRedstoneface(pos, state);
            }
        }
        return new TileEntityPhantomItemface(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return switch (this.type) {
            case Type.PLACER, Type.BREAKER -> {
                if (level.isClientSide) {
                    yield TileEntityPhantomPlacer::clientTick;
                }
                yield TileEntityPhantomPlacer::serverTick;
            }
            case Type.LIQUIFACE -> {
                if (level.isClientSide) {
                    yield TileEntityPhantomLiquiface::clientTick;
                }
                yield TileEntityPhantomLiquiface::serverTick;
            }
            case Type.ENERGYFACE -> {
                if (level.isClientSide) {
                    yield TileEntityPhantomEnergyface::clientTick;
                }
                yield TileEntityPhantomEnergyface::serverTick;
            }
            case Type.REDSTONEFACE -> {
                if (level.isClientSide) {
                    yield TileEntityPhantomRedstoneface::clientTick;
                }
                yield TileEntityPhantomRedstoneface::serverTick;
            }
            default -> level.isClientSide ? TileEntityPhantomItemface::clientTick : TileEntityPhantomItemface::serverTick;
        };
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tile;
        if (this.tryToggleRedstone(world, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        if (!world.isClientSide && (tile = world.getBlockEntity(pos)) instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)tile;
            player.openMenu(menuProvider, pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displayHud(GuiGraphics guiGraphics, Minecraft minecraft, Player player, ItemStack stack, HitResult rayCast, Window resolution) {
        if (!(rayCast instanceof BlockHitResult)) {
            return;
        }
        BlockPos pos = ((BlockHitResult)rayCast).getBlockPos();
        BlockEntity tile = minecraft.level.getBlockEntity(pos);
        if (tile != null && tile instanceof IPhantomTile) {
            IPhantomTile phantom = (IPhantomTile)tile;
            guiGraphics.drawString(minecraft.font, (Component)Component.translatable((String)"tooltip.actuallyadditions.blockPhantomRange.desc").append(": " + phantom.getRange()).withStyle(ChatFormatting.GOLD), resolution.getGuiScaledWidth() / 2 + 5, resolution.getGuiScaledHeight() / 2 - 40, ChatFormatting.WHITE.getColor().intValue());
            if (phantom.hasBoundPosition()) {
                int distance = Mth.ceil((double)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).distanceTo(new Vec3((double)phantom.getBoundPosition().getX(), (double)phantom.getBoundPosition().getY(), (double)phantom.getBoundPosition().getZ())));
                BlockState state = minecraft.level.getBlockState(phantom.getBoundPosition());
                Block block = state.getBlock();
                Item item = Item.byBlock((Block)block);
                String name = item.getName(new ItemStack((ItemLike)block)).getString();
                BlockPhantom.drawWordWrap(guiGraphics, minecraft.font, (FormattedText)Component.translatable((String)"tooltip.actuallyadditions.phantom.blockInfo.desc", (Object[])new Object[]{name, phantom.getBoundPosition().getX(), phantom.getBoundPosition().getY(), phantom.getBoundPosition().getZ(), distance}), resolution.getGuiScaledWidth() / 2 + 5, resolution.getGuiScaledHeight() / 2 - 30, 200, 0xFFFFFF, true);
                if (phantom.isBoundThingInRange()) {
                    BlockPhantom.drawWordWrap(guiGraphics, minecraft.font, (FormattedText)Component.translatable((String)"tooltip.actuallyadditions.phantom.connectedRange.desc"), resolution.getGuiScaledWidth() / 2 + 5, resolution.getGuiScaledHeight() / 2 + 25, 200, 0xFFFFFF, true);
                } else {
                    BlockPhantom.drawWordWrap(guiGraphics, minecraft.font, (FormattedText)Component.translatable((String)"tooltip.actuallyadditions.phantom.connectedNoRange.desc"), resolution.getGuiScaledWidth() / 2 + 5, resolution.getGuiScaledHeight() / 2 + 25, 200, 0xFFFFFF, true);
                }
            } else {
                guiGraphics.drawString(minecraft.font, (Component)Component.translatable((String)"tooltip.actuallyadditions.phantom.notConnected.desc").withStyle(ChatFormatting.RED), resolution.getGuiScaledWidth() / 2 + 5, resolution.getGuiScaledHeight() / 2 + 25, ChatFormatting.WHITE.getColor().intValue());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawWordWrap(GuiGraphics gg, Font font, FormattedText text, int x, int y, int width, int color, boolean shadow) {
        for (FormattedCharSequence line : font.split(text, width)) {
            gg.drawString(font, line, x, y, color, shadow);
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    public static enum Type {
        ITEMFACE,
        PLACER,
        BREAKER,
        LIQUIFACE,
        ENERGYFACE,
        REDSTONEFACE;

    }
}

