/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import com.mojang.blaze3d.platform.Window;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPlayerInterface;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockPlayerInterface
extends BlockContainerBase
implements IHudDisplay {
    public BlockPlayerInterface() {
        super(ActuallyBlocks.defaultPickProps(4.5f, 10.0f));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityPlayerInterface(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return level.isClientSide ? TileEntityPlayerInterface::clientTick : TileEntityPlayerInterface::serverTick;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileEntityPlayerInterface) {
            TileEntityPlayerInterface face = (TileEntityPlayerInterface)tile;
            if (face.connectedPlayer == null) {
                face.connectedPlayer = player.getUUID();
                face.playerName = player.getName().getString();
                face.setChanged();
                face.sendUpdate();
            }
        }
        super.setPlacedBy(world, pos, state, player, stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displayHud(GuiGraphics guiGraphics, Minecraft minecraft, Player player, ItemStack stack, HitResult rayCast, Window resolution) {
        if (!(rayCast instanceof BlockHitResult)) {
            return;
        }
        BlockEntity tile = minecraft.level.getBlockEntity(((BlockHitResult)rayCast).getBlockPos());
        if (tile != null && tile instanceof TileEntityPlayerInterface) {
            TileEntityPlayerInterface face = (TileEntityPlayerInterface)tile;
            String name = face.playerName == null ? "Unknown" : face.playerName;
            guiGraphics.drawString(minecraft.font, "Bound to: " + ChatFormatting.RED + name, (int)((float)resolution.getGuiScaledWidth() / 2.0f + 5.0f), (int)((float)resolution.getGuiScaledHeight() / 2.0f + 5.0f), 0xFFFFFF);
            guiGraphics.drawString(minecraft.font, "UUID: " + ChatFormatting.DARK_GREEN + face.connectedPlayer, (int)((float)resolution.getGuiScaledWidth() / 2.0f + 5.0f), (int)((float)resolution.getGuiScaledHeight() / 2.0f + 15.0f), 0xFFFFFF);
        }
    }
}

