/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import com.mojang.blaze3d.platform.Window;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.base.DirectionalBlock;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityVerticalDigger;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockVerticalDigger
extends DirectionalBlock.Container
implements IHudDisplay {
    public BlockVerticalDigger() {
        super(ActuallyBlocks.defaultPickProps(8.0f, 30.0f));
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return this.openGui(worldIn, player, pos, TileEntityVerticalDigger.class);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityVerticalDigger(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return level.isClientSide ? TileEntityVerticalDigger::clientTick : TileEntityVerticalDigger::serverTick;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displayHud(GuiGraphics guiGraphics, Minecraft minecraft, Player player, ItemStack stack, HitResult rayCast, Window resolution) {
        if (!(rayCast instanceof BlockHitResult)) {
            return;
        }
        BlockEntity tile = minecraft.level.getBlockEntity(((BlockHitResult)rayCast).getBlockPos());
        if (tile instanceof TileEntityVerticalDigger) {
            TileEntityVerticalDigger miner = (TileEntityVerticalDigger)tile;
            String info = miner.checkY == 0 ? "Done Mining!" : (miner.checkY == -1 ? "Calculating positions..." : "Mining at " + (miner.getBlockPos().getX() + miner.checkX) + ", " + miner.checkY + ", " + (miner.getBlockPos().getZ() + miner.checkZ) + ".");
            guiGraphics.drawString(minecraft.font, info, (int)((float)resolution.getGuiScaledWidth() / 2.0f + 5.0f), (int)((float)resolution.getGuiScaledHeight() / 2.0f - 20.0f), 0xFFFFFF);
        }
    }
}

