/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.base;

import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public abstract class BlockContainerBase
extends Block
implements EntityBlock {
    public BlockContainerBase(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult openGui(Level world, Player player, BlockPos pos, Class<? extends MenuProvider> expectedInstance) {
        if (!world.isClientSide) {
            BlockEntity tile = world.getBlockEntity(pos);
            if (expectedInstance.isInstance(tile)) {
                player.openMenu((MenuProvider)tile, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private void dropInventory(Level world, BlockPos position) {
        BlockEntity aTile;
        if (!world.isClientSide && (aTile = world.getBlockEntity(position)) instanceof TileEntityInventoryBase) {
            TileEntityInventoryBase tile = (TileEntityInventoryBase)aTile;
            if (tile.inv.getSlots() > 0) {
                for (int i = 0; i < tile.inv.getSlots(); ++i) {
                    this.dropSlotFromInventory(i, tile, world, position);
                }
            }
        }
    }

    private void dropSlotFromInventory(int i, TileEntityInventoryBase tile, Level world, BlockPos pos) {
        ItemStack stack = tile.inv.getStackInSlot(i);
        if (stack.isEmpty()) {
            return;
        }
        float dX = world.random.nextFloat() * 0.8f + 0.1f;
        float dY = world.random.nextFloat() * 0.8f + 0.1f;
        float dZ = world.random.nextFloat() * 0.8f + 0.1f;
        ItemEntity entityItem = new ItemEntity(world, (double)((float)pos.getX() + dX), (double)((float)pos.getY() + dY), (double)((float)pos.getZ() + dZ), stack.copy());
        float factor = 0.05f;
        entityItem.push(world.random.nextGaussian() * (double)factor, world.random.nextGaussian() * (double)factor + (double)0.2f, world.random.nextGaussian() * (double)factor);
        world.addFreshEntity((Entity)entityItem);
    }

    public boolean tryToggleRedstone(Level world, BlockPos pos, Player player) {
        BlockEntity tile;
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() == CommonConfig.Other.redstoneConfigureItem && (tile = world.getBlockEntity(pos)) instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            if (!world.isClientSide && base.isRedstoneToggle()) {
                base.isPulseMode = !base.isPulseMode;
                base.setChanged();
                base.sendUpdate();
            }
            return true;
        }
        return false;
    }

    public void tick(@Nonnull BlockState state, ServerLevel world, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        TileEntityBase base;
        BlockEntity tile;
        if (!world.isClientSide && (tile = world.getBlockEntity(pos)) instanceof TileEntityBase && (base = (TileEntityBase)tile).respondsToPulses()) {
            base.activateOnPulse();
        }
    }

    public void neighborsChangedCustom(Level world, BlockPos pos) {
        TileEntityBase base;
        this.updateRedstoneState(world, pos);
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileEntityBase && (base = (TileEntityBase)tile).shouldSaveDataOnChangeOrWorldStart()) {
            base.saveDataOnChangeOrWorldStart();
        }
    }

    public void neighborChanged(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        this.neighborsChangedCustom(worldIn, pos);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        if (world instanceof Level) {
            this.neighborsChangedCustom((Level)world, pos);
        }
    }

    public void updateRedstoneState(Level world, BlockPos pos) {
        BlockEntity tile;
        if (!world.isClientSide && (tile = world.getBlockEntity(pos)) instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            boolean powered = world.getBestNeighborSignal(pos) > 0;
            boolean wasPowered = base.isRedstonePowered;
            if (powered && !wasPowered) {
                if (base.respondsToPulses()) {
                    base.activateOnPulse();
                }
                base.setRedstonePowered(true);
            } else if (!powered && wasPowered) {
                base.setRedstonePowered(false);
            }
        }
    }

    protected boolean tryUseItemOnTank(Player player, InteractionHand hand, FluidTank tank) {
        ItemStack heldItem = player.getItemInHand(hand);
        return StackUtil.isValid(heldItem) && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)tank);
    }

    public void onPlace(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        this.updateRedstoneState(worldIn, pos);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tile;
        if (stack.hasTag() && (tile = world.getBlockEntity(pos)) instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)tile;
            CompoundTag compound = stack.getOrCreateTag().getCompound("Data");
            base.readSyncableNBT(compound, TileEntityBase.NBTType.SAVE_BLOCK);
        }
    }

    public BlockState playerWillDestroy(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, Player player) {
        BlockEntity tile;
        BlockState theState = super.playerWillDestroy(world, pos, state, player);
        if (!player.isCreative() && (tile = world.getBlockEntity(pos)) instanceof TileEntityBase && ((TileEntityBase)tile).stopFromDropping) {
            player.displayClientMessage((Component)Component.translatable((String)"info.actuallyadditions.machineBroke").withStyle(ChatFormatting.RED), false);
        }
        return theState;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileEntityBase) {
            return ((TileEntityBase)tile).getComparatorStrength();
        }
        return 0;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock() && this.shouldDropInventory(world, pos)) {
            this.dropInventory(world, pos);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public boolean shouldDropInventory(Level world, BlockPos pos) {
        return true;
    }
}

