/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDisplayStand;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

public class RenderDisplayStand
implements BlockEntityRenderer<TileEntityDisplayStand> {
    public RenderDisplayStand(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityDisplayStand tile, float partialTicks, @Nonnull PoseStack matrices, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        ItemStack stack = tile.inv.getStackInSlot(0);
        if (stack.isEmpty()) {
            return;
        }
        matrices.pushPose();
        matrices.translate(0.5f, 1.0f, 0.5f);
        float boop = (float)Util.getMillis() / 800.0f;
        matrices.translate(0.0, Math.sin((double)boop % (Math.PI * 2)) * 0.065, 0.0);
        matrices.mulPose(Axis.YP.rotationDegrees(boop * 40.0f % 360.0f));
        float scale = stack.getItem() instanceof BlockItem ? 0.85f : 0.65f;
        matrices.scale(scale, scale, scale);
        try {
            AssetUtil.renderItemInWorld(stack, combinedLightIn, combinedOverlayIn, matrices, buffer);
        }
        catch (Exception e) {
            ActuallyAdditions.LOGGER.error("Something went wrong trying to render an item in a display stand! The item is " + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()) + "!", (Throwable)e);
        }
        matrices.popPose();
    }
}

