/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemEngineerGoggles;
import de.ellpeck.actuallyadditions.mod.items.ItemLaserWrench;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RenderLaserRelay
implements BlockEntityRenderer<TileEntityLaserRelay> {
    private static final int COLOR = 0xFF0000;
    private static final int COLOR_ITEM = 31760;
    private static final int COLOR_FLUIDS = 25030;
    private static final int COLOR_INFRARED = 13743087;

    public RenderLaserRelay(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityLaserRelay tile, float partialTicks, PoseStack matrices, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ConcurrentSet<IConnectionPair> connections;
        TileEntityLaserRelay relay = tile;
        BlockState state = tile.getBlockState();
        boolean hasInvis = false;
        LocalPlayer player = Minecraft.getInstance().player;
        boolean hasGoggles = ItemEngineerGoggles.isWearing((Player)player);
        ItemStack upgrade = relay.inv.getStackInSlot(0);
        if (StackUtil.isValid(upgrade)) {
            if (upgrade.getItem() == ActuallyItems.LASER_UPGRADE_INVISIBILITY.get()) {
                hasInvis = true;
            }
            ItemStack hand = player.getMainHandItem();
            if (hasGoggles || StackUtil.isValid(hand) && (hand.getItem() == CommonConfig.Other.relayConfigureItem || hand.getItem() instanceof ItemLaserWrench) || "themattabase".equals(player.getName().getString())) {
                matrices.pushPose();
                Direction direction = state.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)state.getValue((Property)BlockStateProperties.FACING) : Direction.UP;
                float yTrans = direction.getAxis() == Direction.Axis.Y ? 0.2f : 0.8f;
                matrices.translate(0.5f, yTrans, 0.5f);
                matrices.scale(0.2f, 0.2f, 0.2f);
                double boop = (double)Util.getMillis() / 800.0;
                matrices.mulPose(Axis.YP.rotationDegrees((float)(boop * 40.0 % 360.0)));
                AssetUtil.renderItemInWorld(upgrade, combinedLight, combinedOverlay, matrices, buffer);
                matrices.popPose();
            }
        }
        if ((connections = tile.getConnections()) != null && !connections.isEmpty()) {
            for (IConnectionPair pair : connections) {
                boolean otherInvis;
                if (pair.doesSuppressRender() || !tile.getBlockPos().equals((Object)pair.getPositions()[0])) continue;
                BlockPos first = tile.getBlockPos();
                BlockPos second = pair.getPositions()[1];
                BlockEntity secondTile = tile.getLevel().getBlockEntity(second);
                if (!(secondTile instanceof TileEntityLaserRelay)) continue;
                ItemStack secondUpgrade = ((TileEntityLaserRelay)secondTile).inv.getStackInSlot(0);
                boolean bl = otherInvis = StackUtil.isValid(secondUpgrade) && secondUpgrade.getItem() == ActuallyItems.LASER_UPGRADE_INVISIBILITY.get();
                if (!hasGoggles && hasInvis && otherInvis) continue;
                int color = hasInvis && otherInvis ? 13743087 : (relay.type == LaserType.ITEM ? 31760 : (relay.type == LaserType.FLUID ? 25030 : 0xFF0000));
                BlockPos offsetStart = first.subtract((Vec3i)tile.getBlockPos());
                BlockPos offsetEnd = second.subtract((Vec3i)tile.getBlockPos());
                offsetEnd = offsetEnd.rotate(Rotation.CLOCKWISE_90);
                matrices.pushPose();
                AssetUtil.renderLaser(matrices, buffer, new Vec3((double)offsetStart.getX(), (double)offsetStart.getY(), (double)offsetStart.getZ()), new Vec3((double)offsetEnd.getX(), (double)offsetEnd.getY(), (double)offsetEnd.getZ()), 120.0f, color, hasInvis && otherInvis ? 0.1f : 0.35f, 0.05f);
                matrices.popPose();
            }
        }
    }

    public boolean shouldRenderOffScreen(TileEntityLaserRelay tile) {
        return true;
    }

    public AABB getRenderBoundingBox(TileEntityLaserRelay blockEntity) {
        return INFINITE_EXTENT_AABB;
    }

    public int getViewDistance() {
        return 32;
    }
}

