/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CoffeeIngredientRecipe
implements Recipe<Container> {
    public static final String NAME = "coffee_ingredient";
    protected final Ingredient ingredient;
    protected final NonNullList<EffectInstance> instances;
    protected final List<MobEffectInstance> effects;
    protected final int maxAmplifier;
    protected final String extraText;

    public CoffeeIngredientRecipe(Ingredient ingredient, NonNullList<EffectInstance> effectInstances, int maxAmplifier, String extraText) {
        EffectInstance instance;
        MobEffect effect;
        this.ingredient = ingredient;
        this.maxAmplifier = maxAmplifier;
        this.instances = effectInstances;
        ArrayList<MobEffectInstance> instances = new ArrayList<MobEffectInstance>();
        Iterator iterator = effectInstances.iterator();
        while (iterator.hasNext() && (effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get((instance = (EffectInstance)iterator.next()).effect())) != null) {
            instances.add(new MobEffectInstance(effect, instance.duration, instance.amplifier));
        }
        this.effects = instances;
        this.extraText = extraText;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    public int getMaxAmplifier() {
        return this.maxAmplifier;
    }

    public String getExtraText() {
        return this.extraText;
    }

    public boolean matches(Container container, Level level) {
        return false;
    }

    public boolean matches(ItemStack itemStack) {
        return this.ingredient.test(itemStack);
    }

    public ItemStack assemble(Container container, RegistryAccess registryAccess) {
        return this.getResultItem(registryAccess);
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.COFFEE_INGREDIENT_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.COFFEE_INGREDIENT.get();
    }

    public boolean effect(ItemStack stack) {
        return ActuallyAdditionsAPI.methodHandler.addRecipeEffectToStack(stack, this);
    }

    public static Optional<RecipeHolder<CoffeeIngredientRecipe>> getIngredientForStack(ItemStack ingredient) {
        return ActuallyAdditionsAPI.COFFEE_MACHINE_INGREDIENTS.stream().filter(recipe -> ((CoffeeIngredientRecipe)recipe.value()).matches(ingredient)).findFirst();
    }

    public record EffectInstance(ResourceLocation effect, int duration, int amplifier) {
        public static final EffectInstance EMPTY = new EffectInstance(new ResourceLocation("darkness"), 0, 0);
        public static final Codec<EffectInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("effect").forGetter(effect -> effect.effect), (App)Codec.INT.fieldOf("duration").forGetter(effect -> effect.duration), (App)Codec.INT.fieldOf("amplifier").forGetter(effect -> effect.amplifier)).apply((Applicative)instance, EffectInstance::new));

        public EffectInstance(MobEffectInstance effect) {
            this(BuiltInRegistries.MOB_EFFECT.getKey((Object)effect.getEffect()), effect.getDuration(), effect.getAmplifier());
        }

        public static EffectInstance fromNetwork(FriendlyByteBuf pBuffer) {
            ResourceLocation effect = pBuffer.readResourceLocation();
            int duration = pBuffer.readVarInt();
            int amplifier = pBuffer.readVarInt();
            return new EffectInstance(effect, duration, amplifier);
        }

        public void toNetwork(FriendlyByteBuf pBuffer) {
            pBuffer.writeResourceLocation(this.effect);
            pBuffer.writeVarInt(this.duration);
            pBuffer.writeVarInt(this.amplifier);
        }
    }

    public static class Serializer
    implements RecipeSerializer<CoffeeIngredientRecipe> {
        private static final Codec<CoffeeIngredientRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)EffectInstance.CODEC.listOf().optionalFieldOf("effects", new ArrayList()).flatXmap(list -> {
            for (EffectInstance effect : list) {
                if (BuiltInRegistries.MOB_EFFECT.containsKey(effect.effect)) continue;
                return DataResult.error(() -> "Unknown effect: %s".formatted(effect.effect));
            }
            return DataResult.success((Object)NonNullList.of((Object)EffectInstance.EMPTY, (Object[])((EffectInstance[])list.toArray(EffectInstance[]::new))));
        }, DataResult::success).forGetter(recipe -> recipe.instances), (App)Codec.INT.fieldOf("maxAmplifier").forGetter(recipe -> recipe.maxAmplifier), (App)Codec.STRING.optionalFieldOf("extraText", (Object)"").forGetter(recipe -> recipe.extraText)).apply((Applicative)instance, CoffeeIngredientRecipe::new));

        public Codec<CoffeeIngredientRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public CoffeeIngredientRecipe fromNetwork(@Nonnull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)pBuffer);
            int i = pBuffer.readVarInt();
            NonNullList list = NonNullList.withSize((int)i, (Object)EffectInstance.EMPTY);
            for (int j = 0; j < list.size(); ++j) {
                list.set(j, (Object)EffectInstance.fromNetwork(pBuffer));
            }
            int maxAmplifier = pBuffer.readInt();
            String extraText = pBuffer.readUtf(Short.MAX_VALUE);
            return new CoffeeIngredientRecipe(ingredient, (NonNullList<EffectInstance>)list, maxAmplifier, extraText);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, CoffeeIngredientRecipe pRecipe) {
            pRecipe.ingredient.toNetwork(pBuffer);
            pBuffer.writeVarInt(pRecipe.instances.size());
            for (EffectInstance effect : pRecipe.instances) {
                effect.toNetwork(pBuffer);
            }
            pBuffer.writeInt(pRecipe.maxAmplifier);
            pBuffer.writeUtf(pRecipe.extraText);
        }
    }
}

