/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ColorChangeRecipe
implements Recipe<Container> {
    public static final String NAME = "color_change";
    private final Ingredient input;
    private final ItemStack output;

    public ColorChangeRecipe(ItemStack output, Ingredient input) {
        this.input = input;
        this.output = output;
    }

    public boolean matches(@Nonnull Container pInv, @Nonnull Level pLevel) {
        return this.input.test(pInv.getItem(0));
    }

    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(Container pInv, RegistryAccess pRegistryAccess) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public static Optional<RecipeHolder<ColorChangeRecipe>> getRecipeForStack(ItemStack stack) {
        return ActuallyAdditionsAPI.COLOR_CHANGE_RECIPES.stream().filter(recipe -> ((ColorChangeRecipe)recipe.value()).matches(stack)).findFirst();
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess pRegistryAccess) {
        return this.output.copy();
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.COLOR_CHANGE_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.COLOR_CHANGE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ColorChangeRecipe> {
        private static final Codec<ColorChangeRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input)).apply((Applicative)instance, ColorChangeRecipe::new));

        public Codec<ColorChangeRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public ColorChangeRecipe fromNetwork(@Nonnull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)pBuffer);
            ItemStack result = pBuffer.readItem();
            return new ColorChangeRecipe(result, ingredient);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, ColorChangeRecipe pRecipe) {
            pRecipe.input.toNetwork(pBuffer);
            pBuffer.writeItem(pRecipe.output);
        }
    }
}

