/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CrushingRecipe
implements Recipe<Container> {
    public static String NAME = "crushing";
    protected Ingredient input;
    protected NonNullList<CrushingResult> outputs;

    public CrushingRecipe(Ingredient input, NonNullList<CrushingResult> outputList) {
        this.input = input;
        this.outputs = outputList;
    }

    public CrushingRecipe(Ingredient input, ItemStack outputOne, float chance1, ItemStack outputTwo, float chance2) {
        this(input, CrushingRecipe.createList(new CrushingResult(outputOne, chance1), new CrushingResult(outputTwo, chance2)));
    }

    private static NonNullList<CrushingResult> createList(CrushingResult ... results) {
        NonNullList list = NonNullList.create();
        for (CrushingResult result : results) {
            list.add((Object)result);
        }
        return list;
    }

    public boolean matches(Container pInv, Level pLevel) {
        return this.input.test(pInv.getItem(0));
    }

    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(Container pInv, RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess pRegistryAccess) {
        return ((CrushingResult)this.outputs.get((int)0)).stack.copy();
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.CRUSHING_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.CRUSHING.get();
    }

    public ItemStack getOutputOne() {
        return ((CrushingResult)this.outputs.get((int)0)).stack;
    }

    public ItemStack getOutputTwo() {
        return ((CrushingResult)this.outputs.get((int)1)).stack;
    }

    public float getFirstChance() {
        return ((CrushingResult)this.outputs.get((int)0)).chance;
    }

    public float getSecondChance() {
        return ((CrushingResult)this.outputs.get((int)1)).chance;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public record CrushingResult(ItemStack stack, float chance) {
        public static final CrushingResult EMPTY = new CrushingResult(ItemStack.EMPTY, 0.0f);
    }

    public static class Serializer
    implements RecipeSerializer<CrushingRecipe> {
        private static final Codec<CrushingResult> RESULT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(result -> result.stack), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.chance))).apply((Applicative)instance, CrushingResult::new));
        private static final Codec<CrushingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)RESULT_CODEC.listOf().fieldOf("result").flatXmap(array -> {
            CrushingResult[] resultArray = (CrushingResult[])array.toArray(CrushingResult[]::new);
            NonNullList results = NonNullList.withSize((int)2, (Object)CrushingResult.EMPTY);
            if (resultArray.length < 1) {
                return DataResult.error(() -> "Recipe must contain at least 1 result");
            }
            if (resultArray.length > 2) {
                return DataResult.error(() -> "Too many results for crushing recipe. The maximum is: 2");
            }
            for (int i = 0; i < resultArray.length; ++i) {
                results.set(i, (Object)resultArray[i]);
            }
            return DataResult.success((Object)results);
        }, DataResult::success).forGetter(recipe -> recipe.outputs)).apply((Applicative)instance, CrushingRecipe::new));

        public Codec<CrushingRecipe> codec() {
            return CODEC;
        }

        public CrushingRecipe fromNetwork(@Nonnull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)pBuffer);
            int i = pBuffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)CrushingResult.EMPTY);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)new CrushingResult(pBuffer.readItem(), pBuffer.readFloat()));
            }
            return new CrushingRecipe(ingredient, (NonNullList<CrushingResult>)nonnulllist);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, CrushingRecipe pRecipe) {
            pRecipe.input.toNetwork(pBuffer);
            pBuffer.writeVarInt(pRecipe.outputs.size());
            for (CrushingResult result : pRecipe.outputs) {
                pBuffer.writeItem(result.stack);
                pBuffer.writeFloat(result.chance);
            }
        }
    }
}

