/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.inventory.gui.FluidDisplay;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class FermentingRecipe
implements Recipe<Container> {
    public static final String NAME = "fermenting";
    private final FluidStack input;
    private final FluidStack output;
    private final int time;
    private Optional<FluidDisplay> inputDisplay;
    private Optional<FluidDisplay> outputDisplay;

    public FermentingRecipe(FluidStack input, FluidStack output, int timeIn) {
        this.input = input;
        this.output = output;
        this.time = timeIn;
    }

    public boolean matches(FluidStack stack) {
        return stack.isFluidEqual(this.input);
    }

    public boolean matches(FluidStack input, FluidStack output) {
        return input.isFluidEqual(this.input) && (output.isEmpty() || output.isFluidEqual(this.output) && input.getAmount() >= this.input.getAmount());
    }

    public Optional<FluidDisplay> getInputDisplay() {
        return this.inputDisplay;
    }

    public void setInputDisplay(FluidDisplay inputDisplay) {
        this.inputDisplay = Optional.of(inputDisplay);
    }

    public Optional<FluidDisplay> getOutputDisplay() {
        return this.outputDisplay;
    }

    public void setOutputDisplay(FluidDisplay outputDisplay) {
        this.outputDisplay = Optional.of(outputDisplay);
    }

    public int getTime() {
        return this.time;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public FluidStack getInput() {
        return this.input;
    }

    public boolean matches(Container pInv, Level pLevel) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(Container pInv, RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.FERMENTING_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.FERMENTING.get();
    }

    public static class Serializer
    implements RecipeSerializer<FermentingRecipe> {
        private static final Codec<FermentingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidStack.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)FluidStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.INT.fieldOf("time").forGetter(recipe -> recipe.time)).apply((Applicative)instance, FermentingRecipe::new));

        public Codec<FermentingRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public FermentingRecipe fromNetwork(@Nonnull FriendlyByteBuf pBuffer) {
            FluidStack input = FluidStack.readFromPacket((FriendlyByteBuf)pBuffer);
            FluidStack output = FluidStack.readFromPacket((FriendlyByteBuf)pBuffer);
            int time = pBuffer.readInt();
            return new FermentingRecipe(input, output, time);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, @Nonnull FermentingRecipe pRecipe) {
            pRecipe.input.writeToPacket(pBuffer);
            pRecipe.output.writeToPacket(pBuffer);
            pBuffer.writeInt(pRecipe.time);
        }
    }
}

