/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LaserRecipe
implements Recipe<Container> {
    public static String NAME = "laser";
    private ItemStack result;
    private Ingredient itemIngredient;
    private int energy;

    public LaserRecipe(ItemStack result, Ingredient itemIngredient, int energy) {
        this.result = result;
        this.itemIngredient = itemIngredient;
        this.energy = energy;
    }

    public int getEnergy() {
        return this.energy;
    }

    public boolean matches(ItemStack itemStack, int energyIn) {
        return this.itemIngredient.test(itemStack) && energyIn >= this.energy;
    }

    public boolean matches(ItemStack itemStack) {
        return this.itemIngredient.test(itemStack);
    }

    public Ingredient getInput() {
        return this.itemIngredient;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ActuallyBlocks.ATOMIC_RECONSTRUCTOR.get());
    }

    public boolean matches(Container pInv, Level pLevel) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack assemble(Container pInv, RegistryAccess pRegistryAccess) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.LASER_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.LASER.get();
    }

    public static Optional<RecipeHolder<LaserRecipe>> getRecipeForStack(ItemStack stack) {
        return ActuallyAdditionsAPI.CONVERSION_LASER_RECIPES.stream().filter(recipe -> ((LaserRecipe)recipe.value()).matches(stack)).findFirst();
    }

    public boolean validInput(ItemStack stack) {
        return LaserRecipe.getRecipeForStack(stack).isPresent();
    }

    public static class Serializer
    implements RecipeSerializer<LaserRecipe> {
        private static final Codec<LaserRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.RESULT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.itemIngredient), (App)Codec.INT.fieldOf("energy").forGetter(recipe -> recipe.energy)).apply((Applicative)instance, LaserRecipe::new));

        public Codec<LaserRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public LaserRecipe fromNetwork(@Nonnull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)pBuffer);
            int energy = pBuffer.readInt();
            ItemStack result = pBuffer.readItem();
            return new LaserRecipe(result, ingredient, energy);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, LaserRecipe pRecipe) {
            pRecipe.itemIngredient.toNetwork(pBuffer);
            pBuffer.writeInt(pRecipe.energy);
            pBuffer.writeItem(pRecipe.result);
        }
    }
}

