/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class LiquidFuelRecipe
implements Recipe<Container> {
    public static String NAME = "liquid_fuel";
    private FluidStack fuel;
    private int burnTime;
    private int totalEnergy;

    public LiquidFuelRecipe(FluidStack fuel, int totalEnergy, int burnTime) {
        this.fuel = fuel;
        this.burnTime = burnTime;
        this.totalEnergy = totalEnergy;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getTotalEnergy() {
        return this.totalEnergy;
    }

    public boolean matches(@Nonnull Container pInv, @Nonnull Level pLevel) {
        return false;
    }

    public boolean matches(FluidStack stack) {
        return this.fuel.isFluidEqual(stack);
    }

    public boolean isSpecial() {
        return true;
    }

    public int getFuelAmount() {
        return this.fuel.getAmount();
    }

    public FluidStack getFuel() {
        return this.fuel;
    }

    @Nonnull
    public ItemStack assemble(Container pInv, RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.LIQUID_FUEL_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.LIQUID_FUEL.get();
    }

    public static class Serializer
    implements RecipeSerializer<LiquidFuelRecipe> {
        private static final Codec<LiquidFuelRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidStack.CODEC.fieldOf("fuel").forGetter(recipe -> recipe.fuel), (App)Codec.INT.fieldOf("total_energy").forGetter(recipe -> recipe.totalEnergy), (App)Codec.INT.fieldOf("burn_time").forGetter(recipe -> recipe.burnTime)).apply((Applicative)instance, LiquidFuelRecipe::new));

        public Codec<LiquidFuelRecipe> codec() {
            return CODEC;
        }

        public LiquidFuelRecipe fromNetwork(@Nonnull FriendlyByteBuf pBuffer) {
            FluidStack input = FluidStack.readFromPacket((FriendlyByteBuf)pBuffer);
            int totalEnergy = pBuffer.readInt();
            int burnTime = pBuffer.readInt();
            return new LiquidFuelRecipe(input, totalEnergy, burnTime);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, LiquidFuelRecipe pRecipe) {
            pRecipe.fuel.writeToPacket(pBuffer);
            pBuffer.writeInt(pRecipe.totalEnergy);
            pBuffer.writeInt(pRecipe.burnTime);
        }
    }
}

