/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class MiningLensRecipe
implements Recipe<Container>,
WeightedEntry {
    public static final String NAME = "mining_lens";
    private final int weight;
    private final Ingredient input;
    private final ItemStack output;

    public MiningLensRecipe(Ingredient input, int weight, ItemStack output) {
        this.weight = weight;
        this.input = input;
        this.output = output;
    }

    public Weight getWeight() {
        return Weight.of((int)this.weight);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public boolean matches(ItemStack test) {
        return this.input.test(test);
    }

    public boolean matches(Container pInv, Level pLevel) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(Container pInv, RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(RegistryAccess pRegistryAccess) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.MINING_LENS_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.MINING_LENS.get();
    }

    public static class Serializer
    implements RecipeSerializer<MiningLensRecipe> {
        private static final Codec<MiningLensRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)Codec.INT.fieldOf("weight").forGetter(recipe -> recipe.weight), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(recipe -> recipe.output)).apply((Applicative)instance, MiningLensRecipe::new));

        public Codec<MiningLensRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public MiningLensRecipe fromNetwork(@Nonnull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)pBuffer);
            int weight = pBuffer.readInt();
            ItemStack result = pBuffer.readItem();
            return new MiningLensRecipe(ingredient, weight, result);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, MiningLensRecipe pRecipe) {
            pRecipe.input.toNetwork(pBuffer);
            pBuffer.writeInt(pRecipe.weight);
            pBuffer.writeItem(pRecipe.output);
        }
    }
}

