/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class PressingRecipe
implements Recipe<Container> {
    public static final String NAME = "pressing";
    private final Ingredient input;
    private final FluidStack output;

    public PressingRecipe(Ingredient input, FluidStack output) {
        this.input = input;
        this.output = output;
    }

    public boolean matches(@Nonnull Container pInv, @Nullable Level pLevel) {
        return this.input.test(pInv.getItem(0));
    }

    public boolean isSpecial() {
        return true;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack assemble(Container pInv, RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public ItemStack getResultItem(RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.PRESSING_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.PRESSING.get();
    }

    public static class Serializer
    implements RecipeSerializer<PressingRecipe> {
        private static final Codec<PressingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(recipe -> recipe.output)).apply((Applicative)instance, PressingRecipe::new));

        public Codec<PressingRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public PressingRecipe fromNetwork(@Nonnull FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)pBuffer);
            FluidStack output = FluidStack.readFromPacket((FriendlyByteBuf)pBuffer);
            return new PressingRecipe(ingredient, output);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf pBuffer, @Nonnull PressingRecipe pRecipe) {
            pRecipe.input.toNetwork(pBuffer);
            pRecipe.output.writeToPacket(pBuffer);
        }
    }
}

