/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.serialization.Codec;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.TargetNBTIngredient;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.neoforged.neoforge.attachment.AttachmentUtils;

public class RecipeKeepDataShapeless
extends ShapelessRecipe {
    public static String NAME = "copy_nbt_shapeless";

    public RecipeKeepDataShapeless(String pGroup, CraftingBookCategory pCategory, ItemStack pResult, NonNullList<Ingredient> pIngredients) {
        super(pGroup, pCategory, pResult, pIngredients);
    }

    public RecipeKeepDataShapeless(ShapelessRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), recipe.getResultItem((RegistryAccess)RegistryAccess.EMPTY), recipe.getIngredients());
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.KEEP_DATA_SHAPELESS_RECIPE.get();
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        ItemStack result = super.assemble(pContainer, pRegistryAccess);
        TargetNBTIngredient donorIngredient = null;
        ItemStack datasource = ItemStack.EMPTY;
        NonNullList ingredients = this.getIngredients();
        for (Ingredient ingredient : ingredients) {
            if (!(ingredient instanceof TargetNBTIngredient)) continue;
            donorIngredient = (TargetNBTIngredient)ingredient;
            break;
        }
        if (donorIngredient != null && !pContainer.isEmpty()) {
            for (int i = 0; i < pContainer.getContainerSize(); ++i) {
                ItemStack item = pContainer.getItem(i);
                if (item.isEmpty() || !donorIngredient.test(item)) continue;
                datasource = item;
                break;
            }
        }
        if (datasource.isEmpty() || !datasource.hasTag()) {
            ActuallyAdditions.LOGGER.info("AA.KeepDataShapeless missing TargetNBTIngredient");
            return ItemStack.EMPTY;
        }
        result.setTag(datasource.getTag().copy());
        if (!datasource.isEmpty()) {
            AttachmentUtils.copyStackAttachments((ItemStack)datasource, (ItemStack)result);
        }
        return result;
    }

    public static class Serializer
    implements RecipeSerializer<RecipeKeepDataShapeless> {
        public static final Codec<RecipeKeepDataShapeless> CODEC = ShapelessRecipe.Serializer.CODEC.xmap(RecipeKeepDataShapeless::new, $ -> $);

        public Codec<RecipeKeepDataShapeless> codec() {
            return CODEC;
        }

        public RecipeKeepDataShapeless fromNetwork(FriendlyByteBuf pBuffer) {
            return new RecipeKeepDataShapeless((ShapelessRecipe)RecipeSerializer.SHAPELESS_RECIPE.fromNetwork(pBuffer));
        }

        public void toNetwork(FriendlyByteBuf pBuffer, RecipeKeepDataShapeless pRecipe) {
            try {
                RecipeSerializer.SHAPELESS_RECIPE.toNetwork(pBuffer, (Recipe)pRecipe);
            }
            catch (Exception e) {
                ActuallyAdditions.LOGGER.info("Failed to serialize " + NAME + " Recipe to packet: " + e.getMessage());
                throw e;
            }
        }
    }
}

