/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.SingleItem;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class SolidFuelRecipe
implements Recipe<SingleItem> {
    public static String NAME = "solid_fuel";
    private Ingredient itemIngredient;
    private int burnTime;
    private int totalEnergy;

    public SolidFuelRecipe(Ingredient itemIngredient, int totalEnergy, int burnTime) {
        this.itemIngredient = itemIngredient;
        this.burnTime = burnTime;
        this.totalEnergy = totalEnergy;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getTotalEnergy() {
        return this.totalEnergy;
    }

    public boolean matches(SingleItem pInv, Level pLevel) {
        return this.itemIngredient.test(pInv.getItem());
    }

    public boolean matches(ItemStack stack) {
        return this.itemIngredient.test(stack);
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack assemble(SingleItem pInv, RegistryAccess registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.SOLID_FUEL_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.SOLID_FUEL.get();
    }

    public static class Serializer
    implements RecipeSerializer<SolidFuelRecipe> {
        private static final Codec<SolidFuelRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("item").forGetter(recipe -> recipe.itemIngredient), (App)Codec.INT.fieldOf("total_energy").forGetter(recipe -> recipe.totalEnergy), (App)Codec.INT.fieldOf("burn_time").forGetter(recipe -> recipe.burnTime)).apply((Applicative)instance, SolidFuelRecipe::new));

        public Codec<SolidFuelRecipe> codec() {
            return CODEC;
        }

        public SolidFuelRecipe fromNetwork(FriendlyByteBuf pBuffer) {
            Ingredient itemIngredient = Ingredient.fromNetwork((FriendlyByteBuf)pBuffer);
            int totalEnergy = pBuffer.readInt();
            int burnTime = pBuffer.readInt();
            return new SolidFuelRecipe(itemIngredient, totalEnergy, burnTime);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, SolidFuelRecipe pRecipe) {
            pRecipe.itemIngredient.toNetwork(pBuffer);
            pBuffer.writeInt(pRecipe.totalEnergy);
            pBuffer.writeInt(pRecipe.burnTime);
        }
    }
}

