/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.serialization.Codec;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class TargetNBTIngredient
extends Ingredient {
    public static final Codec<TargetNBTIngredient> CODEC = Ingredient.VANILLA_CODEC.xmap(TargetNBTIngredient::new, TargetNBTIngredient::new);

    public TargetNBTIngredient(Stream<? extends Ingredient.Value> itemLists) {
        super(itemLists, ActuallyRecipes.Ingredients.TARGET_NBT);
    }

    public TargetNBTIngredient(Ingredient ingredient) {
        super(Arrays.stream(ingredient.values), ActuallyRecipes.Ingredients.TARGET_NBT);
    }

    public boolean test(@Nullable ItemStack pStack) {
        return super.test(pStack);
    }

    public static TargetNBTIngredient of(ItemLike itemProvider) {
        return new TargetNBTIngredient(Stream.of(new Ingredient.ItemValue(new ItemStack(itemProvider))));
    }

    public static TargetNBTIngredient of(ItemStack itemStack) {
        return new TargetNBTIngredient(Stream.of(new Ingredient.ItemValue(itemStack)));
    }

    public static TargetNBTIngredient of(@Nonnull TagKey<Item> tag) {
        return new TargetNBTIngredient(Stream.of(new Ingredient.TagValue(tag)));
    }
}

