/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.data;

import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.LaserRelayConnectionHandler;
import io.netty.util.internal.ConcurrentSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class WorldData
extends SavedData {
    public static final String DATA_TAG = "actuallyadditionsdata";
    public static final String SAVE_NAME = "actuallyadditions_worldsave";
    private static WorldData data;
    public final ConcurrentSet<Network> laserRelayNetworks = new ConcurrentSet();
    public final ConcurrentHashMap<UUID, PlayerData.PlayerSave> playerSaveData = new ConcurrentHashMap();

    public static WorldData get(Level level) {
        return (WorldData)((ServerLevel)level).getDataStorage().computeIfAbsent(new SavedData.Factory(WorldData::new, WorldData::load), SAVE_NAME);
    }

    public static void clear() {
        if (data != null) {
            data = null;
            ActuallyAdditions.LOGGER.info("Unloaded WorldData!");
        }
    }

    public static WorldData load(CompoundTag compound) {
        WorldData worldData = new WorldData();
        worldData.laserRelayNetworks.clear();
        ListTag networkList = compound.getList("Networks", 10);
        for (int i = 0; i < networkList.size(); ++i) {
            Network network = LaserRelayConnectionHandler.readNetworkFromNBT(networkList.getCompound(i));
            worldData.laserRelayNetworks.add((Object)network);
        }
        worldData.playerSaveData.clear();
        ListTag playerList = compound.getList("PlayerData", 10);
        for (int i = 0; i < playerList.size(); ++i) {
            CompoundTag player = playerList.getCompound(i);
            UUID id = player.getUUID("UUID");
            CompoundTag data = player.getCompound("Data");
            PlayerData.PlayerSave save = new PlayerData.PlayerSave(id);
            save.readFromNBT(data, true);
            worldData.playerSaveData.put(id, save);
        }
        return worldData;
    }

    public CompoundTag save(CompoundTag compound) {
        ListTag networkList = new ListTag();
        for (Network network : this.laserRelayNetworks) {
            networkList.add((Object)LaserRelayConnectionHandler.writeNetworkToNBT(network));
        }
        compound.put("Networks", (Tag)networkList);
        ListTag playerList = new ListTag();
        for (PlayerData.PlayerSave save : this.playerSaveData.values()) {
            CompoundTag player = new CompoundTag();
            player.putUUID("UUID", save.id);
            CompoundTag data = new CompoundTag();
            save.writeToNBT(data, true);
            player.put("Data", (Tag)data);
            playerList.add((Object)player);
        }
        compound.put("PlayerData", (Tag)playerList);
        return compound;
    }
}

