/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.entity;

import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer.DefaultFarmerBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.FarmlandWaterManager;
import net.neoforged.neoforge.common.IPlantable;
import net.neoforged.neoforge.common.ticket.AABBTicket;

public class EntityWorm
extends Entity {
    public int timer;
    private AABBTicket waterTicket;

    public EntityWorm(EntityType<?> type, Level world) {
        super(type, world);
        this.setBoundingBox(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
    }

    public static boolean canWormify(Level world, BlockPos pos, BlockState state) {
        boolean rightBlock;
        Block block = state.getBlock();
        boolean bl = rightBlock = block instanceof FarmBlock || block == Blocks.DIRT || block instanceof GrassBlock;
        if (rightBlock) {
            BlockPos posUp = pos.above();
            BlockState stateUp = world.getBlockState(posUp);
            Block blockUp = stateUp.getBlock();
            return blockUp instanceof IPlantable || blockUp instanceof BushBlock || stateUp.canBeReplaced();
        }
        return false;
    }

    public void remove(Entity.RemovalReason reason) {
        if (this.waterTicket != null) {
            this.waterTicket.invalidate();
        }
        super.remove(reason);
    }

    protected void removeAfterChangingDimensions() {
        if (this.waterTicket != null) {
            this.waterTicket.invalidate();
        }
        super.removeAfterChangingDimensions();
    }

    public void setPos(double pX, double pY, double pZ) {
        super.setPos(pX, pY, pZ);
        if (this.level().isClientSide) {
            return;
        }
        if (this.waterTicket != null) {
            this.waterTicket.invalidate();
        }
        AABB aabb = new AABB(this.getX() - 1.5, this.getY() - 1.5, this.getZ() - 1.0, this.getX() + 1.5, this.getY() + 0.5, this.getZ() + 1.5);
        this.waterTicket = FarmlandWaterManager.addAABBTicket((Level)this.level(), (AABB)aabb);
    }

    public boolean canUpdate() {
        return true;
    }

    public void tick() {
        if (!this.level().isClientSide) {
            int dieTime;
            ++this.timer;
            if (this.timer % 50 == 0) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        boolean isMiddlePose;
                        BlockPos pos = BlockPos.containing((double)(this.getX() + (double)x), (double)this.getY(), (double)(this.getZ() + (double)z));
                        BlockState state = this.level().getBlockState(pos);
                        Block block = state.getBlock();
                        boolean bl = isMiddlePose = x == 0 && z == 0;
                        if (EntityWorm.canWormify(this.level(), pos, state)) {
                            BlockState plantState;
                            Block plantBlock;
                            boolean isFarmland = block instanceof FarmBlock;
                            if (!isFarmland && (isMiddlePose || this.level().random.nextFloat() >= 0.45f)) {
                                DefaultFarmerBehavior.useHoeAt(this.level(), pos);
                            }
                            if (!isFarmland || !(this.level().random.nextFloat() >= 0.95f)) continue;
                            BlockPos plant = pos.above();
                            if (this.level().isEmptyBlock(plant) || !((plantBlock = (plantState = this.level().getBlockState(plant)).getBlock()) instanceof BonemealableBlock) && !(plantBlock instanceof IPlantable) || plantBlock instanceof GrassBlock) continue;
                            plantBlock.randomTick(plantState, (ServerLevel)this.level(), plant, this.level().random);
                            BlockState newState = this.level().getBlockState(plant);
                            if (newState == plantState) continue;
                            this.level().levelEvent(2005, plant, 0);
                            continue;
                        }
                        if (!isMiddlePose) continue;
                        this.removeAfterChangingDimensions();
                    }
                }
            }
            if ((dieTime = ((Integer)CommonConfig.Other.WORMS_DIE_TIME.get()).intValue()) > 0 && this.timer >= dieTime) {
                this.removeAfterChangingDimensions();
            }
        }
    }

    protected void defineSynchedData() {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.timer = compound.getInt("Timer");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Timer", this.timer);
    }
}

