/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.fluids;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredItem;

public class FluidAA
implements Supplier<Fluid> {
    private String name;
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private Supplier<FluidType> fluidType;
    private Supplier<BaseFlowingFluid> source;
    private Supplier<BaseFlowingFluid> flowing;
    private Supplier<LiquidBlock> fluidBlock;
    private DeferredItem<Item> bucket;

    public String getName() {
        return this.name;
    }

    public static BaseFlowingFluid.Properties createProperties(Supplier<FluidType> type, Supplier<BaseFlowingFluid> still, Supplier<BaseFlowingFluid> flowing, DeferredItem<Item> bucket, Supplier<LiquidBlock> block) {
        return new BaseFlowingFluid.Properties(type, still, flowing).bucket(bucket).block(block);
    }

    public FluidAA(String fluidName, String textureName) {
        this.name = fluidName;
        this.stillTexture = new ResourceLocation("actuallyadditions", "block/" + textureName + "_still");
        this.flowingTexture = new ResourceLocation("actuallyadditions", "block/" + textureName + "_flowing");
        this.fluidType = InitFluids.FLUID_TYPES.register(this.name, () -> new FluidType(FluidAA.createTypeProperties()){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return FluidAA.this.stillTexture;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return FluidAA.this.flowingTexture;
                    }
                });
            }
        });
        this.source = InitFluids.FLUIDS.register(this.name, () -> new BaseFlowingFluid.Source(FluidAA.createProperties(this.fluidType, this.source, this.flowing, this.bucket, this.fluidBlock)));
        this.flowing = InitFluids.FLUIDS.register(this.name + "_flowing", () -> new BaseFlowingFluid.Flowing(FluidAA.createProperties(this.fluidType, this.source, this.flowing, this.bucket, this.fluidBlock)));
        this.fluidBlock = ActuallyBlocks.BLOCKS.register(this.name, () -> new LiquidBlock(this.source, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
        this.bucket = ActuallyItems.ITEMS.register(this.name + "_bucket", () -> new BucketItem(this.source, new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
    }

    public FluidType getFluidType() {
        return this.fluidType.get();
    }

    @Override
    public Fluid get() {
        return (Fluid)this.source.get();
    }

    public Block getBlock() {
        return (Block)this.fluidBlock.get();
    }

    public Item getBucket() {
        return (Item)this.bucket.get();
    }

    public FlowingFluid getFlowing() {
        return (FlowingFluid)this.flowing.get();
    }

    public static FluidType.Properties createTypeProperties() {
        return FluidType.Properties.create().canSwim(true).canDrown(true).pathType(BlockPathTypes.LAVA).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY);
    }
}

