/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotItemHandlerUnconditioned;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotOutput;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemCoffee;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerCoffeeMachine
extends AbstractContainerMenu {
    public final TileEntityCoffeeMachine machine;

    public static ContainerCoffeeMachine fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ContainerCoffeeMachine(windowId, inv, (TileEntityCoffeeMachine)Objects.requireNonNull(inv.player.level().getBlockEntity(data.readBlockPos())));
    }

    public ContainerCoffeeMachine(int windowId, Inventory inventory, TileEntityCoffeeMachine tile) {
        super(ActuallyContainers.COFFEE_MACHINE_CONTAINER.get(), windowId);
        int j;
        int i;
        this.machine = tile;
        this.addSlot((Slot)new SlotItemHandlerUnconditioned(this.machine.inv, 0, 37, 6));
        this.addSlot((Slot)new SlotItemHandlerUnconditioned(this.machine.inv, 1, 80, 42));
        this.addSlot((Slot)new SlotOutput(this.machine.inv, 2, 80, 73));
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 2; ++j) {
                this.addSlot((Slot)new SlotItemHandlerUnconditioned(this.machine.inv, j + i * 2 + 3, 125 + j * 18, 6 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 97 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 155));
        }
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        int inventoryStart = 11;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.slots.get(slot);
        if (theSlot != null && theSlot.hasItem()) {
            ItemStack newStack = theSlot.getItem();
            ItemStack currentStack = newStack.copy();
            if (slot == 2) {
                if (!this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, true)) {
                    return ItemStack.EMPTY;
                }
                theSlot.onQuickCraft(newStack, currentStack);
            } else if (slot >= inventoryStart ? (newStack.getItem() == ActuallyItems.EMPTY_CUP.get() ? !this.moveItemStackTo(newStack, 1, 2, false) : (ItemCoffee.getIngredientRecipeFromStack(newStack) != null ? !this.moveItemStackTo(newStack, 3, 11, false) : (newStack.is(ActuallyTags.Items.COFFEE_BEANS) ? !this.moveItemStackTo(newStack, 0, 1, false) : (slot >= inventoryStart && slot <= inventoryEnd ? !this.moveItemStackTo(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.moveItemStackTo(newStack, inventoryStart, inventoryEnd + 1, false))))) : !this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (!StackUtil.isValid(newStack)) {
                theSlot.set(ItemStack.EMPTY);
            } else {
                theSlot.setChanged();
            }
            if (newStack.getCount() == currentStack.getCount()) {
                return ItemStack.EMPTY;
            }
            theSlot.onTake(player, newStack);
            return currentStack;
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.machine.canPlayerUse(player);
    }
}

