/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import com.mojang.datafixers.util.Pair;
import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotItemHandlerUnconditioned;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotOutput;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEnergizer;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.Nullable;

public class ContainerEnergizer
extends AbstractContainerMenu {
    public static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public final TileEntityEnergizer energizer;

    public static ContainerEnergizer fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ContainerEnergizer(windowId, inv, (TileEntityEnergizer)Objects.requireNonNull(inv.player.level().getBlockEntity(data.readBlockPos())));
    }

    public ContainerEnergizer(int windowId, Inventory inventory, TileEntityEnergizer tile) {
        super(ActuallyContainers.ENERGIZER_CONTAINER.get(), windowId);
        int i;
        this.energizer = tile;
        this.addSlot((Slot)new SlotItemHandlerUnconditioned(this.energizer.inv, 0, 76, 73){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return super.mayPlace(stack) && stack.getCapability(Capabilities.EnergyStorage.ITEM, null) != null;
            }
        });
        this.addSlot((Slot)new SlotOutput(this.energizer.inv, 1, 76, 42));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 97 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 155));
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot slot = VALID_EQUIPMENT_SLOTS[k];
            this.addSlot(new Slot((Container)inventory, 39 - k, 102, 19 + k * 18){

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(ItemStack stack) {
                    return StackUtil.isValid(stack) && stack.getItem() instanceof ArmorItem;
                }

                public boolean mayPickup(Player player) {
                    ItemStack itemstack = this.getItem();
                    return (itemstack.isEmpty() || player.isCreative() || !EnchantmentHelper.hasBindingCurse((ItemStack)itemstack)) && super.mayPickup(player);
                }

                @Nullable
                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.TEXTURE_EMPTY_SLOTS[slot.getIndex()]);
                }
            });
        }
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        int inventoryStart = 2;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.slots.get(slot);
        if (theSlot != null && theSlot.hasItem()) {
            ItemStack newStack = theSlot.getItem();
            ItemStack currentStack = newStack.copy();
            if (slot == 1) {
                if (!this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, true)) {
                    return ItemStack.EMPTY;
                }
                theSlot.onQuickCraft(newStack, currentStack);
            } else if (slot >= inventoryStart ? (newStack.getCapability(Capabilities.EnergyStorage.ITEM, null) != null ? !this.moveItemStackTo(newStack, 0, 1, false) : (slot >= inventoryStart && slot <= inventoryEnd ? !this.moveItemStackTo(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.moveItemStackTo(newStack, inventoryStart, inventoryEnd + 1, false))) : !this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (!StackUtil.isValid(newStack)) {
                theSlot.set(ItemStack.EMPTY);
            } else {
                theSlot.setChanged();
            }
            if (newStack.getCount() == currentStack.getCount()) {
                return ItemStack.EMPTY;
            }
            theSlot.onTake(player, newStack);
            return currentStack;
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.energizer.canPlayerUse(player);
    }
}

