/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotFilter;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotImmovable;
import de.ellpeck.actuallyadditions.mod.items.DrillItem;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ContainerFilter
extends AbstractContainerMenu {
    public static final int SLOT_AMOUNT = 24;
    private final ItemStackHandlerAA filterInventory = new ItemStackHandlerAA(24);
    private final Inventory inventory;

    public static ContainerFilter fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ContainerFilter(windowId, inv);
    }

    public ContainerFilter(int windowId, Inventory inventory) {
        super(ActuallyContainers.FILTER_CONTAINER.get(), windowId);
        int j;
        int i;
        this.inventory = inventory;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 6; ++j) {
                this.addSlot((Slot)new SlotFilter(this.filterInventory, j + i * 6, 35 + j * 18, 10 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 94 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == inventory.selected) {
                this.addSlot(new SlotImmovable((Container)inventory, i, 8 + i * 18, 152));
                continue;
            }
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 152));
        }
        ItemStack stack = inventory.getSelected();
        if (SlotFilter.isFilter(stack)) {
            DrillItem.loadSlotsFromNBT((IItemHandlerModifiable)this.filterInventory, inventory.getSelected());
        }
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        int inventoryStart = 24;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.slots.get(slot);
        if (theSlot != null && theSlot.hasItem()) {
            ItemStack newStack = theSlot.getItem();
            ItemStack currentStack = newStack.copy();
            if (slot >= inventoryStart ? (slot >= inventoryStart && slot <= inventoryEnd ? !this.moveItemStackTo(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.moveItemStackTo(newStack, inventoryStart, inventoryEnd + 1, false)) : !this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (!StackUtil.isValid(newStack)) {
                theSlot.set(ItemStack.EMPTY);
            } else {
                theSlot.setChanged();
            }
            if (newStack.getCount() == currentStack.getCount()) {
                return ItemStack.EMPTY;
            }
            theSlot.onTake(player, newStack);
            return currentStack;
        }
        return ItemStack.EMPTY;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (SlotFilter.checkFilter(this, slotId, player)) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP && dragType == this.inventory.selected) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public void removed(Player player) {
        ItemStack stack = this.inventory.getSelected();
        if (SlotFilter.isFilter(stack)) {
            DrillItem.writeSlotsToNBT((IItemHandler)this.filterInventory, this.inventory.getSelected());
        }
        super.removed(player);
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

