/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotItemHandlerUnconditioned;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotOutput;
import de.ellpeck.actuallyadditions.mod.recipe.CrusherRecipeRegistry;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCrusher;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CrusherContainer
extends AbstractContainerMenu {
    public final TileEntityCrusher tileGrinder;
    public final boolean isDouble;

    public CrusherContainer(int windowId, Inventory inventory, TileEntityCrusher tile) {
        super(ActuallyContainers.GRINDER_CONTAINER.get(), windowId);
        int i;
        this.tileGrinder = tile;
        this.isDouble = tile.isDouble;
        this.addSlot((Slot)new SlotItemHandlerUnconditioned(this.tileGrinder.inv, 0, this.isDouble ? 51 : 80, 21));
        this.addSlot((Slot)new SlotOutput(this.tileGrinder.inv, 1, this.isDouble ? 37 : 66, 69));
        this.addSlot((Slot)new SlotOutput(this.tileGrinder.inv, 2, this.isDouble ? 64 : 92, 69));
        if (this.isDouble) {
            this.addSlot((Slot)new SlotItemHandlerUnconditioned(this.tileGrinder.inv, 3, 109, 21));
            this.addSlot((Slot)new SlotOutput(this.tileGrinder.inv, 4, 96, 69));
            this.addSlot((Slot)new SlotOutput(this.tileGrinder.inv, 5, 121, 69));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 97 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 155));
        }
    }

    public static CrusherContainer fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new CrusherContainer(windowId, inv, (TileEntityCrusher)Objects.requireNonNull(inv.player.level().getBlockEntity(data.readBlockPos())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack quickMoveStack(Player player, int slot) {
        int inventoryStart = this.isDouble ? 6 : 3;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.slots.get(slot);
        if (theSlot == null || !theSlot.hasItem()) return ItemStack.EMPTY;
        ItemStack newStack = theSlot.getItem();
        ItemStack currentStack = newStack.copy();
        if (slot == 1 || slot == 2 || this.isDouble && (slot == 4 || slot == 5)) {
            if (!this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, true)) {
                return ItemStack.EMPTY;
            }
            theSlot.onQuickCraft(newStack, currentStack);
        } else if (slot >= inventoryStart) {
            if (CrusherRecipeRegistry.getRecipeFromInput(newStack) != null) {
                if (!this.moveItemStackTo(newStack, 0, 1, false)) {
                    if (!this.isDouble) return ItemStack.EMPTY;
                    if (!this.moveItemStackTo(newStack, 3, 4, false)) {
                        return ItemStack.EMPTY;
                    }
                }
            } else if (slot >= inventoryStart && slot <= inventoryEnd ? !this.moveItemStackTo(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.moveItemStackTo(newStack, inventoryStart, inventoryEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
        } else if (!this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, false)) {
            return ItemStack.EMPTY;
        }
        if (!StackUtil.isValid(newStack)) {
            theSlot.set(ItemStack.EMPTY);
        } else {
            theSlot.setChanged();
        }
        if (newStack.getCount() == currentStack.getCount()) {
            return ItemStack.EMPTY;
        }
        theSlot.onTake(player, newStack);
        return currentStack;
    }

    public boolean stillValid(Player player) {
        return this.tileGrinder.canPlayerUse(player);
    }
}

