/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory;

import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.inventory.ActuallyContainers;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotFilter;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotImmovable;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotItemHandlerUnconditioned;
import de.ellpeck.actuallyadditions.mod.items.Sack;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SackContainer
extends AbstractContainerMenu
implements IButtonReactor {
    public final FilterSettings filter = new FilterSettings(4, false, false, false, false);
    private final ItemStackHandlerAA bagInventory;
    private final Inventory inventory;
    public boolean autoInsert;
    private boolean oldAutoInsert;
    public static final int SIZE = 28;

    public static SackContainer fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new SackContainer(windowId, inv, data.readUUID(), new ItemStackHandlerAA(28));
    }

    public SackContainer(int windowId, Inventory playerInventory, UUID uuid, ItemStackHandlerAA handler) {
        super(ActuallyContainers.SACK_CONTAINER.get(), windowId);
        int col;
        int row;
        this.inventory = playerInventory;
        this.bagInventory = handler;
        for (row = 0; row < 4; ++row) {
            this.addSlot((Slot)new SlotFilter(this.filter, row, 155, 10 + row * 18));
        }
        for (row = 0; row < 4; ++row) {
            for (col = 0; col < 7; ++col) {
                this.addSlot((Slot)new SlotItemHandlerUnconditioned(this.bagInventory, col + row * 7, 10 + col * 18, 10 + row * 18){

                    @Override
                    public boolean mayPlace(ItemStack stack) {
                        return !stack.is(ActuallyTags.Items.HOLDS_ITEMS) && SackContainer.this.filter.check(stack);
                    }
                });
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 94 + row * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (i == playerInventory.selected) {
                this.addSlot(new SlotImmovable((Container)playerInventory, i, 8 + i * 18, 152));
                continue;
            }
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 152));
        }
        ItemStack stack = playerInventory.getSelected();
        if (!stack.isEmpty() && stack.getItem() instanceof Sack && stack.hasTag()) {
            CompoundTag compound = stack.getOrCreateTag();
            this.filter.readFromNBT(compound, "Filter");
            this.autoInsert = compound.getBoolean("AutoInsert");
        }
    }

    public ItemStack quickMoveStack(@Nonnull Player player, int slot) {
        int inventoryStart = this.bagInventory.getSlots() + 4;
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot theSlot = (Slot)this.slots.get(slot);
        if (theSlot != null && theSlot.hasItem()) {
            ItemStack newStack = theSlot.getItem();
            ItemStack currentStack = newStack.copy();
            if (slot >= inventoryStart ? (!this.filter.check(newStack) || !this.moveItemStackTo(newStack, 4, 32, false)) && (slot <= inventoryEnd ? !this.moveItemStackTo(newStack, hotbarStart, hotbarEnd + 1, false) : slot >= inventoryEnd + 1 && slot < hotbarEnd + 1 && !this.moveItemStackTo(newStack, inventoryStart, inventoryEnd + 1, false)) : !this.moveItemStackTo(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (newStack.isEmpty()) {
                theSlot.set(ItemStack.EMPTY);
            } else {
                theSlot.setChanged();
            }
            if (newStack.getCount() == currentStack.getCount()) {
                return ItemStack.EMPTY;
            }
            theSlot.onTake(player, newStack);
            return currentStack;
        }
        return ItemStack.EMPTY;
    }

    public void clicked(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull Player player) {
        if (SlotFilter.checkFilter(this, slotId, player)) {
            return;
        }
        if (clickTypeIn == ClickType.SWAP && dragType == this.inventory.selected) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public void removed(@Nonnull Player player) {
        ItemStack stack = this.inventory.getSelected();
        if (!stack.isEmpty() && stack.getItem() instanceof Sack) {
            CompoundTag compound = stack.getOrCreateTag();
            this.filter.writeToNBT(compound, "Filter");
            compound.putBoolean("AutoInsert", this.autoInsert);
        }
        super.removed(player);
    }

    public boolean stillValid(@Nonnull Player player) {
        return true;
    }

    @Override
    public void onButtonPressed(int buttonID, Player player) {
        if (buttonID == 0) {
            this.autoInsert = !this.autoInsert;
        } else {
            this.filter.onButtonPressed(buttonID - 1);
        }
    }
}

