/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class Buttons {

    @OnlyIn(value=Dist.CLIENT)
    public static class TinyButton
    extends Button {
        public final ResourceLocation resLoc = AssetUtil.getGuiLocation("gui_inputter");

        public TinyButton(int id, int x, int y) {
            super(x, y, 8, 8, (Component)Component.literal((String)""), Button::onPress, DEFAULT_NARRATION);
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
            if (this.visible) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int k = !this.active ? 0 : (this.isHoveredOrFocused() ? 2 : 1);
                GlStateManager._enableBlend();
                GlStateManager.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                GlStateManager._blendFunc((int)770, (int)771);
                guiGraphics.blit(this.resLoc, this.getX(), this.getY(), 192, k * 8, 8, 8);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Deprecated(forRemoval=true)
    public static class SmallerButton
    extends Button {
        public final ResourceLocation resLoc = AssetUtil.getGuiLocation("gui_inputter");
        private final boolean smaller;

        public SmallerButton(int x, int y, Component display, Button.OnPress pressable) {
            this(x, y, display, false, pressable);
        }

        public SmallerButton(int x, int y, Component display, boolean smaller, Button.OnPress pressable) {
            super(x, y, 16, smaller ? 12 : 16, display, pressable, DEFAULT_NARRATION);
            this.smaller = smaller;
        }

        public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
            if (this.visible) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int k = !this.active ? 0 : (this.isHoveredOrFocused() ? 2 : 1);
                GlStateManager._enableBlend();
                GlStateManager.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                GlStateManager._blendFunc((int)770, (int)771);
                guiGraphics.blit(this.resLoc, this.getX(), this.getY(), this.smaller ? 200 : 176, k * this.height, this.width, this.height);
                int color = 0xE0E0E0;
                if (this.packedFGColor != 0) {
                    color = this.packedFGColor;
                } else if (!this.active) {
                    color = 0xA0A0A0;
                } else if (this.isHovered) {
                    color = 0xFFFFA0;
                }
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, this.getMessage().getStyle().getColor().getValue());
            }
        }
    }
}

