/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.inventory.gui.AAScreen;
import de.ellpeck.actuallyadditions.mod.inventory.gui.EnergyDisplay;
import de.ellpeck.actuallyadditions.mod.inventory.gui.FluidDisplay;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.IFluidTank;

@OnlyIn(value=Dist.CLIENT)
public class GuiCoffeeMachine
extends AAScreen<ContainerCoffeeMachine> {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("gui_coffee_machine");
    private final TileEntityCoffeeMachine machine;
    private EnergyDisplay energy;
    private FluidDisplay fluid;

    public GuiCoffeeMachine(ContainerCoffeeMachine container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.machine = container.machine;
        this.imageWidth = 176;
        this.imageHeight = 179;
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"info.actuallyadditions.gui.ok"), b -> PacketHandlerHelper.sendButtonPacket(this.machine, 0)).bounds(this.leftPos + 60, this.topPos + 11, 58, 20).build());
        this.energy = new EnergyDisplay(this.leftPos + 16, this.topPos + 5, this.machine.storage);
        this.fluid = new FluidDisplay(this.leftPos - 30, this.topPos + 1, (IFluidTank)this.machine.tank, true, false);
    }

    @Override
    public void render(@Nonnull GuiGraphics guiGraphics, int x, int y, float f) {
        super.render(guiGraphics, x, y, f);
        Minecraft mc = Minecraft.getInstance();
        MutableComponent text = Component.translatable((String)"info.actuallyadditions.gui.coffee_amount", (Object[])new Object[]{this.machine.coffeeCacheAmount, 300});
        if (x >= this.leftPos + 40 && y >= this.topPos + 25 && x <= this.leftPos + 49 && y <= this.topPos + 56) {
            guiGraphics.renderComponentTooltip(this.font, Collections.singletonList(text), x, y);
        }
        this.energy.render(guiGraphics, x, y);
        this.fluid.render(guiGraphics, x, y);
    }

    public void renderBg(@Nonnull GuiGraphics guiGraphics, float f, int x, int y) {
        int i;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(AssetUtil.GUI_INVENTORY_LOCATION, this.leftPos, this.topPos + 93, 0, 0, 176, 86);
        guiGraphics.blit(RES_LOC, this.leftPos, this.topPos, 0, 0, 176, 93);
        if (this.machine.coffeeCacheAmount > 0) {
            i = this.machine.getCoffeeScaled(30);
            guiGraphics.blit(RES_LOC, this.leftPos + 41, this.topPos + 56 - i, 192, 0, 8, i);
        }
        if (this.machine.brewTime > 0) {
            i = this.machine.getBrewScaled(23);
            guiGraphics.blit(RES_LOC, this.leftPos + 53, this.topPos + 42, 192, 30, i, 16);
            int j = this.machine.getBrewScaled(26);
            guiGraphics.blit(RES_LOC, this.leftPos + 99 + 25 - j, this.topPos + 44, 217 - j, 46, j, 12);
        }
        this.energy.draw(guiGraphics);
        this.fluid.draw(guiGraphics);
    }
}

