/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerFeeder;
import de.ellpeck.actuallyadditions.mod.inventory.gui.AAScreen;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFeeder;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiFeeder
extends AAScreen<ContainerFeeder> {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("gui_feeder");
    public final TileEntityFeeder tileFeeder;

    public GuiFeeder(ContainerFeeder container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.tileFeeder = container.feeder;
        this.imageWidth = 176;
        this.imageHeight = 156;
    }

    @Override
    public void render(@Nonnull GuiGraphics guiGraphics, int x, int y, float f) {
        super.render(guiGraphics, x, y, f);
        if (x >= this.leftPos + 69 && y >= this.topPos + 30 && x <= this.leftPos + 69 + 10 && y <= this.topPos + 30 + 10) {
            List<MutableComponent> array = List.of(Component.literal((String)(this.tileFeeder.currentAnimalAmount + " ")).append((Component)Component.translatable((String)"info.actuallyadditions.gui.animals")), this.tileFeeder.currentAnimalAmount >= 2 && this.tileFeeder.currentAnimalAmount < 30 ? Component.translatable((String)"info.actuallyadditions.gui.enoughToBreed") : (this.tileFeeder.currentAnimalAmount >= 30 ? Component.translatable((String)"info.actuallyadditions.gui.tooMany") : Component.translatable((String)"info.actuallyadditions.gui.notEnough")));
            guiGraphics.renderComponentTooltip(this.font, array, x, y);
        }
    }

    public void renderBg(GuiGraphics guiGraphics, float f, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(AssetUtil.GUI_INVENTORY_LOCATION, this.leftPos, this.topPos + 70, 0, 0, 176, 86);
        guiGraphics.blit(RES_LOC, this.leftPos, this.topPos, 0, 0, 176, 70);
        if (this.tileFeeder.currentTimer > 0) {
            int i = this.tileFeeder.getCurrentTimerToScale(20);
            guiGraphics.blit(RES_LOC, this.leftPos + 85, this.topPos + 42 - i, 181, 38 - i, 6, 20);
        }
        if (this.tileFeeder.currentAnimalAmount >= 2 && this.tileFeeder.currentAnimalAmount < 30) {
            guiGraphics.blit(RES_LOC, this.leftPos + 70, this.topPos + 31, 192, 16, 8, 8);
        }
        if (this.tileFeeder.currentAnimalAmount >= 30) {
            guiGraphics.blit(RES_LOC, this.leftPos + 70, this.topPos + 31, 192, 24, 8, 8);
        }
    }
}

