/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerPhantomPlacer;
import de.ellpeck.actuallyadditions.mod.inventory.gui.AAScreen;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomPlacer;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiPhantomPlacer
extends AAScreen<ContainerPhantomPlacer> {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("gui_breaker");
    private final TileEntityPhantomPlacer placer;
    private Button buttonSide;

    public GuiPhantomPlacer(ContainerPhantomPlacer container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.placer = container.placer;
        this.imageWidth = 176;
        this.imageHeight = 179;
    }

    @Override
    public void init() {
        super.init();
        if (!this.placer.isBreaker) {
            this.buttonSide = Button.builder((Component)Component.literal((String)this.getSide()), button -> PacketHandlerHelper.sendButtonPacket(this.placer, 0)).bounds(this.leftPos + 63, this.topPos + 75, 50, 20).build();
            this.addRenderableWidget((GuiEventListener)this.buttonSide);
        }
    }

    protected void containerTick() {
        super.containerTick();
        if (!this.placer.isBreaker && this.buttonSide != null) {
            this.buttonSide.setMessage((Component)Component.literal((String)this.getSide()));
        }
    }

    @Override
    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (!this.placer.isBreaker && this.buttonSide.isMouseOver((double)mouseX, (double)mouseY)) {
            String loc = "info.actuallyadditions.placer.sides";
            ArrayList<MutableComponent> textList = new ArrayList<MutableComponent>();
            textList.add(Component.translatable((String)(loc + ".1")).withStyle(ChatFormatting.GOLD));
            textList.add(Component.translatable((String)(loc + ".2")));
            guiGraphics.renderComponentTooltip(this.font, textList, mouseX, mouseY);
        }
    }

    private String getSide() {
        return SIDES[this.placer.side + 1];
    }

    public void renderBg(GuiGraphics guiGraphics, float f, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(AssetUtil.GUI_INVENTORY_LOCATION, this.leftPos, this.topPos + 93, 0, 0, 176, 86);
        guiGraphics.blit(RES_LOC, this.leftPos, this.topPos, 0, 0, 176, 93);
    }
}

