/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerRangedCollector;
import de.ellpeck.actuallyadditions.mod.inventory.gui.AAScreen;
import de.ellpeck.actuallyadditions.mod.inventory.gui.FilterSettingsGui;
import de.ellpeck.actuallyadditions.mod.network.PacketClientToServer;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityRangedCollector;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class GuiRangedCollector
extends AAScreen<ContainerRangedCollector> {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("gui_ranged_collector");
    private final TileEntityRangedCollector collector;
    private FilterSettingsGui filter;

    public GuiRangedCollector(ContainerRangedCollector container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.collector = container.collector;
        this.imageWidth = 176;
        this.imageHeight = 172;
    }

    @Override
    public void init() {
        super.init();
        this.filter = new FilterSettingsGui(this.collector.filter, this.leftPos + 3, this.topPos + 6, true, x$0 -> {
            AbstractButton cfr_ignored_0 = (AbstractButton)this.addRenderableWidget((GuiEventListener)x$0);
        }, this::buttonClicked, 0);
    }

    @Override
    public void render(@Nonnull GuiGraphics guiGraphics, int x, int y, float f) {
        super.render(guiGraphics, x, y, f);
        this.filter.drawHover(guiGraphics, x, y);
    }

    public void containerTick() {
        super.containerTick();
        this.filter.tick();
    }

    public void renderBg(GuiGraphics guiGraphics, float f, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(AssetUtil.GUI_INVENTORY_LOCATION, this.leftPos, this.topPos + 86, 0, 0, 176, 86);
        guiGraphics.blit(RES_LOC, this.leftPos, this.topPos, 0, 0, 176, 86);
    }

    public void buttonClicked(int id) {
        CompoundTag data = new CompoundTag();
        data.putInt("ButtonID", id);
        data.putInt("PlayerID", Minecraft.getInstance().player.getId());
        data.putString("WorldID", Minecraft.getInstance().level.dimension().location().toString());
        data.putInt("X", this.collector.getBlockPos().getX());
        data.putInt("Y", this.collector.getBlockPos().getY());
        data.putInt("Z", this.collector.getBlockPos().getZ());
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketClientToServer(data, PacketHandler.GUI_BUTTON_TO_TILE_HANDLER)});
    }
}

