/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.actuallyadditions.mod.inventory.VoidSackContainer;
import de.ellpeck.actuallyadditions.mod.inventory.gui.AAScreen;
import de.ellpeck.actuallyadditions.mod.inventory.gui.FilterSettingsGui;
import de.ellpeck.actuallyadditions.mod.network.PacketClientToServer;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class VoidSackGui
extends AAScreen<VoidSackContainer> {
    private static final ResourceLocation RES_LOC_VOID = AssetUtil.getGuiLocation("gui_void_bag");
    private final VoidSackContainer container;
    private FilterSettingsGui filter;
    private Button buttonAutoInsert;

    public VoidSackGui(VoidSackContainer container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 133;
        this.container = container;
    }

    @Override
    public void init() {
        super.init();
        this.filter = new FilterSettingsGui(this.container.filter, this.leftPos + 97, this.topPos + 3, false, x$0 -> {
            AbstractButton cfr_ignored_0 = (AbstractButton)this.addRenderableWidget((GuiEventListener)x$0);
        }, this::buttonClicked, 1);
        this.buttonAutoInsert = Button.builder((Component)Component.literal((String)"I").withStyle(this.container.autoInsert ? ChatFormatting.DARK_GREEN : ChatFormatting.RED), button -> {
            this.container.autoInsert = !this.container.autoInsert;
            this.buttonAutoInsert.setMessage((Component)Component.literal((String)(this.container.autoInsert ? "I" : "O")).withStyle(this.container.autoInsert ? ChatFormatting.DARK_GREEN : ChatFormatting.RED));
            this.buttonClicked(0);
        }).pos(this.leftPos - 17, this.topPos + 16).size(20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.buttonAutoInsert);
    }

    public void buttonClicked(int id) {
        CompoundTag data = new CompoundTag();
        data.putInt("ButtonID", id);
        data.putInt("PlayerID", Minecraft.getInstance().player.getId());
        data.putString("WorldID", Minecraft.getInstance().level.dimension().location().toString());
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PacketClientToServer(data, PacketHandler.GUI_BUTTON_TO_CONTAINER_HANDLER)});
    }

    public void containerTick() {
        super.containerTick();
        this.filter.tick();
    }

    @Override
    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.filter.drawHover(guiGraphics, mouseX, mouseY);
        if (this.buttonAutoInsert.isMouseOver((double)mouseX, (double)mouseY)) {
            ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
            text.add(Component.literal((String)("Auto-Insert " + (this.container.autoInsert ? "On" : "Off"))).withStyle(ChatFormatting.BOLD));
            text.add(Component.literal((String)"Turn this on to make items that get picked up automatically go into the bag."));
            text.add(Component.literal((String)"Note that this WON'T work when you are holding the bag in your hand.").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
            guiGraphics.renderTooltip(this.font, text, Optional.empty(), mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(AssetUtil.GUI_INVENTORY_LOCATION, this.leftPos, this.topPos + 43, 0, 0, 176, 86);
        guiGraphics.blit(RES_LOC_VOID, this.leftPos, this.topPos, 0, 0, 176, 43);
    }
}

