/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerDrill;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemDrillUpgrade;
import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.TierSortingRegistry;
import net.neoforged.neoforge.common.ToolAction;
import net.neoforged.neoforge.common.ToolActions;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class DrillItem
extends ItemEnergy {
    public static final int HARVEST_LEVEL = 4;
    private static final int ENERGY_USE = 100;
    private static final List<ToolAction> ACTIONS = List.of(ToolActions.SHOVEL_DIG, ToolActions.PICKAXE_DIG);
    private final Multimap<Attribute, AttributeModifier> attributes_unpowered = ArrayListMultimap.create();
    private final Multimap<Attribute, AttributeModifier> attributes_powered = ArrayListMultimap.create();

    public DrillItem() {
        super(ActuallyItems.defaultProps().defaultDurability(0).stacksTo(1), 250000, 1000);
        this.attributes_powered.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Drill Modifier", 8.0, AttributeModifier.Operation.ADDITION));
        this.attributes_powered.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Tool Modifier", 1.5, AttributeModifier.Operation.ADDITION));
        this.attributes_unpowered.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Drill Modifier", (double)0.1f, AttributeModifier.Operation.ADDITION));
        this.attributes_unpowered.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Tool Modifier", 1.5, AttributeModifier.Operation.ADDITION));
    }

    public boolean canPerformAction(@Nonnull ItemStack stack, @Nonnull ToolAction toolAction) {
        return ACTIONS.contains(toolAction);
    }

    public boolean isCorrectToolForDrops(@Nonnull BlockState pBlock) {
        Tiers tier = Tiers.NETHERITE;
        if (TierSortingRegistry.isTierSorted((Tier)tier)) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)pBlock) && pBlock.is(ActuallyTags.Blocks.MINEABLE_WITH_DRILL);
        }
        return pBlock.is(ActuallyTags.Blocks.MINEABLE_WITH_DRILL);
    }

    public static void loadSlotsFromNBT(IItemHandlerModifiable slots, ItemStack stack) {
        CompoundTag compound = stack.getOrCreateTag();
        TileEntityInventoryBase.loadSlots(slots, compound);
    }

    public static void writeSlotsToNBT(IItemHandler slots, ItemStack stack) {
        CompoundTag compound = stack.getOrCreateTag();
        TileEntityInventoryBase.saveSlots(slots, compound);
        stack.setTag(compound);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack equip;
        int slot;
        InteractionHand hand;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = player.getItemInHand(hand = context.getHand());
        ItemStack upgrade = this.getHasUpgradeAsStack(stack, ItemDrillUpgrade.UpgradeType.PLACER);
        if (!upgrade.isEmpty() && (slot = ItemDrillUpgrade.getSlotToPlaceFrom(upgrade)) >= 0 && slot < 9 && !(equip = player.getInventory().getItem(slot)).isEmpty() && equip != stack) {
            ItemStack toPlaceStack = equip;
            BlockHitResult result = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside());
            return toPlaceStack.useOn(new UseOnContext(level, player, hand, toPlaceStack, result));
        }
        return super.useOn(context);
    }

    public ItemStack getHasUpgradeAsStack(ItemStack stack, ItemDrillUpgrade.UpgradeType upgrade) {
        ItemStackHandlerAA inv = new ItemStackHandlerAA(5);
        DrillItem.loadSlotsFromNBT((IItemHandlerModifiable)inv, stack);
        for (int i = 0; i < inv.getSlots(); ++i) {
            Item item;
            ItemStack slotStack = inv.getStackInSlot(i);
            if (slotStack.isEmpty() || !((item = slotStack.getItem()) instanceof ItemDrillUpgrade)) continue;
            ItemDrillUpgrade drillUpgrade = (ItemDrillUpgrade)item;
            if (drillUpgrade.type != upgrade) continue;
            return slotStack;
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!world.isClientSide && player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> new ContainerDrill(id, inv), (Component)Component.translatable((String)"container.actuallyadditions.drill")));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getItemInHand(hand));
    }

    @Nonnull
    public InteractionResult interactLivingEntity(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity entityHit, @Nonnull InteractionHand hand) {
        int use = this.getEnergyUsePerBlock(stack);
        if (!(entityHit instanceof Player && ((Player)entityHit).isCreative() || this.getEnergyStored(stack) < use)) {
            this.extractEnergyInternal(stack, use, false);
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlot slot, @Nonnull ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return this.getEnergyStored(stack) >= 100 ? this.attributes_powered : this.attributes_unpowered;
        }
        return super.getDefaultAttributeModifiers(slot);
    }

    public float getDestroySpeed(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return this.getEnergyStored(stack) >= this.getEnergyUsePerBlock(stack) ? (this.hasExtraWhitelist(state.getBlock()) || state.is(ActuallyTags.Blocks.MINEABLE_WITH_DRILL) ? this.getEfficiencyFromUpgrade(stack) : 1.0f) : 0.1f;
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack stack, @Nonnull BlockPos pos, @Nonnull Player player) {
        boolean toReturn = false;
        int use = this.getEnergyUsePerBlock(stack);
        if (this.getEnergyStored(stack) >= use) {
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SILK_TOUCH)) {
                ItemUtil.addEnchantment(stack, Enchantments.SILK_TOUCH, 1);
            } else if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE)) {
                ItemUtil.addEnchantment(stack, Enchantments.BLOCK_FORTUNE, this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE_II) ? 3 : 1);
            }
            HitResult ray = player.pick(Util.getReachDistance(player), 1.0f, false);
            if (ray instanceof BlockHitResult) {
                BlockHitResult trace = (BlockHitResult)ray;
                toReturn = !player.isShiftKeyDown() && this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE) ? (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE) ? this.breakBlocks(stack, 2, player.level(), pos, trace.getDirection(), player) : this.breakBlocks(stack, 1, player.level(), pos, trace.getDirection(), player)) : this.breakBlocks(stack, 0, player.level(), pos, trace.getDirection(), player);
                ItemUtil.removeEnchantment(stack, Enchantments.SILK_TOUCH);
                ItemUtil.removeEnchantment(stack, Enchantments.BLOCK_FORTUNE);
            }
        }
        return toReturn;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.getEnergyStored(stack) >= this.getEnergyUsePerBlock(stack) && super.isCorrectToolForDrops(stack, state);
    }

    public int getEnergyUsePerBlock(ItemStack stack) {
        int use = 100;
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED)) {
            use += 50;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_II)) {
                use += 75;
                if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_III)) {
                    use += 175;
                }
            }
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SILK_TOUCH)) {
            use += 100;
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE)) {
            use += 40;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE_II)) {
                use += 80;
            }
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
            use += 10;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE)) {
                use += 30;
            }
        }
        return use;
    }

    public boolean getHasUpgrade(ItemStack stack, ItemDrillUpgrade.UpgradeType upgrade) {
        return !this.getHasUpgradeAsStack(stack, upgrade).isEmpty();
    }

    public float getEfficiencyFromUpgrade(ItemStack stack) {
        float efficiency = 8.0f;
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED)) {
            efficiency = this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_II) ? (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_III) ? (efficiency += 37.0f) : (efficiency += 25.0f)) : (efficiency += 8.0f);
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
            efficiency *= 0.5f;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE)) {
                efficiency *= 0.35f;
            }
        }
        return efficiency;
    }

    public boolean breakBlocks(ItemStack stack, int radius, Level world, BlockPos aPos, Direction side, Player player) {
        BlockState theState;
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side.getAxis() == Direction.Axis.Y) {
            zRange = radius;
            yRange = 0;
        }
        if (side.getAxis() == Direction.Axis.X) {
            xRange = 0;
            zRange = radius;
        }
        BlockState state = world.getBlockState(aPos);
        float mainHardness = state.getDestroySpeed((BlockGetter)world, aPos);
        int use = this.getEnergyUsePerBlock(stack);
        if (this.getEnergyStored(stack) >= use) {
            if (!this.tryHarvestBlock(world, aPos, false, stack, player, use)) {
                return false;
            }
        } else {
            return false;
        }
        if (radius == 2 && side.getAxis() != Direction.Axis.Y && (theState = world.getBlockState(aPos = aPos.above())).getDestroySpeed((BlockGetter)world, aPos) <= mainHardness + 5.0f) {
            this.tryHarvestBlock(world, aPos, true, stack, player, use);
        }
        if (radius > 0 && mainHardness >= 0.2f) {
            for (int xPos = aPos.getX() - xRange; xPos <= aPos.getX() + xRange; ++xPos) {
                for (int yPos = aPos.getY() - yRange; yPos <= aPos.getY() + yRange; ++yPos) {
                    for (int zPos = aPos.getZ() - zRange; zPos <= aPos.getZ() + zRange; ++zPos) {
                        if (aPos.getX() == xPos && aPos.getY() == yPos && aPos.getZ() == zPos) continue;
                        if (this.getEnergyStored(stack) >= use) {
                            BlockPos thePos = new BlockPos(xPos, yPos, zPos);
                            BlockState theState2 = world.getBlockState(thePos);
                            if (!(theState2.getDestroySpeed((BlockGetter)world, thePos) <= mainHardness + 5.0f)) continue;
                            this.tryHarvestBlock(world, thePos, true, stack, player, use);
                            continue;
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public List<BlockPos> gatherBreakingPositions(ItemStack stack, int radius, Level world, BlockPos aPos, Direction side, Player player) {
        BlockState theState;
        int energyStored = this.getEnergyStored(stack);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side.getAxis() == Direction.Axis.Y) {
            zRange = radius;
            yRange = 0;
        }
        if (side.getAxis() == Direction.Axis.X) {
            xRange = 0;
            zRange = radius;
        }
        BlockState state = world.getBlockState(aPos);
        float mainHardness = state.getDestroySpeed((BlockGetter)world, aPos);
        int use = this.getEnergyUsePerBlock(stack);
        if (energyStored < use) {
            return positions;
        }
        if (radius == 2 && side.getAxis() != Direction.Axis.Y && (theState = world.getBlockState(aPos = aPos.above())).getDestroySpeed((BlockGetter)world, aPos) <= mainHardness + 5.0f) {
            positions.add(aPos.immutable());
        }
        if (radius > 0 && mainHardness >= 0.2f) {
            for (int xPos = aPos.getX() - xRange; xPos <= aPos.getX() + xRange; ++xPos) {
                for (int yPos = aPos.getY() - yRange; yPos <= aPos.getY() + yRange; ++yPos) {
                    for (int zPos = aPos.getZ() - zRange; zPos <= aPos.getZ() + zRange; ++zPos) {
                        if (aPos.getX() == xPos && aPos.getY() == yPos && aPos.getZ() == zPos) continue;
                        if (energyStored >= use) {
                            BlockPos thePos = new BlockPos(xPos, yPos, zPos);
                            BlockState theState2 = world.getBlockState(thePos);
                            if (!(theState2.getDestroySpeed((BlockGetter)world, thePos) <= mainHardness + 5.0f)) continue;
                            energyStored -= use;
                            positions.add(thePos.immutable());
                            continue;
                        }
                        return positions;
                    }
                }
            }
        }
        return positions;
    }

    private boolean tryHarvestBlock(Level world, BlockPos pos, boolean isExtra, ItemStack stack, Player player, int use) {
        boolean canHarvest;
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        float hardness = state.getDestroySpeed((BlockGetter)world, pos);
        boolean bl = canHarvest = !(!CommonHooks.isCorrectToolForDrops((BlockState)state, (Player)player) && !this.isCorrectToolForDrops(stack, state) || isExtra && !(this.getDestroySpeed(stack, world.getBlockState(pos)) > 1.0f));
        if (hardness >= 0.0f && (!isExtra || canHarvest && !state.hasBlockEntity())) {
            if (!player.isCreative()) {
                this.extractEnergyInternal(stack, use, false);
            }
            return WorldUtil.breakExtraBlock(stack, world, player, pos);
        }
        return false;
    }

    private boolean hasExtraWhitelist(Block block) {
        String name;
        ResourceLocation location;
        if (block != null && (location = BuiltInRegistries.BLOCK.getKey((Object)block)) != null && (name = location.toString()) != null) {
            for (String s : (List)CommonConfig.ItemSettings.DRILL_EXTRA_MINING_WHITELIST.get()) {
                if (s == null || !s.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldCauseBlockBreakReset(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack) {
        return !ItemStack.isSameItem((ItemStack)newStack, (ItemStack)oldStack);
    }
}

