/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import com.mojang.blaze3d.platform.Window;
import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vazkii.patchouli.api.PatchouliAPI;

public class ItemBooklet
extends ItemBase
implements IHudDisplay {
    @OnlyIn(value=Dist.CLIENT)
    public static IBookletPage forcedPage;

    public ItemBooklet() {
        super(ActuallyItems.defaultProps().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (!world.isClientSide) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerAdvancements advancements = serverPlayer.getAdvancements();
            ServerAdvancementManager manager = player.getServer().getAdvancements();
            AdvancementHolder advancement = manager.get(new ResourceLocation("actuallyadditions", "root"));
            if (advancement != null && !advancements.getOrStartProgress(advancement).isDone()) {
                advancements.award(advancement, "right_click");
            }
        } else {
            PatchouliAPI.get().openBookGUI(new ResourceLocation("actuallyadditions", "booklet"));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level playerIn, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)Component.translatable((String)"tooltip.actuallyadditions.item_booklet.desc").withStyle(ChatFormatting.GRAY));
        for (int i = 1; i <= 4; ++i) {
            tooltip.add((Component)Component.translatable((String)("tooltip.actuallyadditions.item_booklet.sub." + i)).withStyle(i == 4 ? ChatFormatting.GOLD : ChatFormatting.RESET).withStyle(i == 4 ? ChatFormatting.ITALIC : ChatFormatting.RESET));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void displayHud(GuiGraphics guiGraphics, Minecraft minecraft, Player player, ItemStack stack, HitResult rayCast, Window resolution) {
    }
}

