/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.misc.IGoggles;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemArmorAA;
import de.ellpeck.actuallyadditions.mod.material.ArmorMaterials;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import io.netty.util.internal.ConcurrentSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;

public class ItemEngineerGoggles
extends ItemArmorAA
implements IGoggles {
    private final Set<Entity> cachedGlowingEntities = new ConcurrentSet();
    private final boolean displayMobs;

    public ItemEngineerGoggles(boolean displayMobs) {
        super(ArmorMaterials.GOGGLES, ArmorItem.Type.HELMET, ActuallyItems.defaultProps().setNoRepair().durability(0));
        this.displayMobs = displayMobs;
        if (FMLEnvironment.dist.isClient()) {
            NeoForge.EVENT_BUS.register((Object)this);
        }
    }

    public static boolean isWearing(Player player) {
        ItemStack face = (ItemStack)player.getInventory().armor.get(3);
        return StackUtil.isValid(face) && face.getItem() instanceof IGoggles;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ItemStack face;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && ItemEngineerGoggles.isWearing((Player)player) && ((IGoggles)(face = (ItemStack)player.getInventory().armor.get(3)).getItem()).displaySpectralMobs()) {
            double range = 8.0;
            AABB aabb = new AABB(player.getX() - range, player.getY() - range, player.getZ() - range, player.getX() + range, player.getY() + range, player.getZ() + range);
            List entities = player.level().getEntitiesOfClass(Entity.class, aabb);
            if (entities != null && !entities.isEmpty()) {
                this.cachedGlowingEntities.addAll(entities);
            }
            if (!this.cachedGlowingEntities.isEmpty()) {
                for (Entity entity : this.cachedGlowingEntities) {
                    if (!entity.isAlive() || entity.distanceToSqr(player.getX(), player.getY(), player.getZ()) > range * range) {
                        entity.setGlowingTag(false);
                        this.cachedGlowingEntities.remove(entity);
                        continue;
                    }
                    entity.setGlowingTag(true);
                }
            }
            return;
        }
        if (!this.cachedGlowingEntities.isEmpty()) {
            for (Entity entity : this.cachedGlowingEntities) {
                if (!entity.isAlive()) continue;
                entity.setGlowingTag(false);
            }
            this.cachedGlowingEntities.clear();
        }
    }

    @Override
    public boolean displaySpectralMobs() {
        return this.displayMobs;
    }
}

