/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.inventory.ContainerFilter;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.DrillItem;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ItemFilter
extends ItemBase {
    public ItemFilter() {
        super(ActuallyItems.defaultProps().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (!world.isClientSide && hand == InteractionHand.MAIN_HAND) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, inv, playerEnt) -> new ContainerFilter(windowId, inv), (Component)Component.translatable((String)"container.actuallyadditions.filter")));
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        ItemStackHandlerAA inv = new ItemStackHandlerAA(24);
        DrillItem.loadSlotsFromNBT((IItemHandlerModifiable)inv, stack);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack slot = inv.getStackInSlot(i);
            if (!StackUtil.isValid(slot)) continue;
            tooltip.add(slot.getItem().getName(slot));
        }
    }
}

