/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.misc.IDisplayStandItem;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.IShearable;

public class ItemLeafBlower
extends ItemBase
implements IDisplayStandItem {
    private final boolean isAdvanced;

    public ItemLeafBlower(boolean isAdvanced) {
        super(ActuallyItems.defaultProps().stacksTo(1));
        this.isAdvanced = isAdvanced;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    @Nonnull
    public UseAnim getUseAnimation(@Nonnull ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(@Nonnull ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        this.doUpdate(level, Mth.floor((double)livingEntity.getX()), Mth.floor((double)livingEntity.getY()), Mth.floor((double)livingEntity.getZ()), remainingUseDuration, stack);
    }

    private boolean doUpdate(Level world, int x, int y, int z, int time, ItemStack stack) {
        if (!world.isClientSide && time <= this.getUseDuration(stack) && (this.isAdvanced || time % 3 == 0)) {
            boolean broke = this.breakStuff(world, x, y, z);
            world.playSound(null, (double)x, (double)y, (double)z, SoundEvents.MINECART_RIDING, SoundSource.PLAYERS, 0.2f, 0.001f);
            return broke;
        }
        return false;
    }

    public boolean breakStuff(Level world, int x, int y, int z) {
        ArrayList<BlockPos> breakPositions = new ArrayList<BlockPos>();
        int rangeSides = 5;
        int rangeUp = 1;
        for (int reachX = -rangeSides; reachX < rangeSides + 1; ++reachX) {
            for (int reachZ = -rangeSides; reachZ < rangeSides + 1; ++reachZ) {
                for (int reachY = this.isAdvanced ? -rangeSides : -rangeUp; reachY < (this.isAdvanced ? rangeSides : rangeUp) + 1; ++reachY) {
                    BlockPos pos = new BlockPos(x + reachX, y + reachY, z + reachZ);
                    Block block = world.getBlockState(pos).getBlock();
                    if (!(block instanceof BushBlock) && !(block instanceof IShearable) || !this.isAdvanced && block instanceof LeavesBlock) continue;
                    breakPositions.add(pos);
                }
            }
        }
        if (!breakPositions.isEmpty()) {
            Collections.shuffle(breakPositions);
            BlockPos pos = (BlockPos)breakPositions.get(0);
            BlockState theState = world.getBlockState(pos);
            world.destroyBlock(pos, true);
            world.levelEvent(2001, pos, Block.getId((BlockState)theState));
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            return true;
        }
        return false;
    }

    @Override
    public boolean update(ItemStack stack, BlockEntity tile, int elapsedTicks) {
        return this.doUpdate(tile.getLevel(), tile.getBlockPos().getX(), tile.getBlockPos().getY(), tile.getBlockPos().getZ(), elapsedTicks, stack);
    }

    @Override
    public int getUsePerTick(ItemStack stack, BlockEntity tile, int elapsedTicks) {
        return 60;
    }
}

