/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemPhantomConnector
extends ItemBase {
    public ItemPhantomConnector() {
        super(ActuallyItems.defaultNonStacking());
    }

    public static ResourceKey<Level> getStoredWorld(ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        if (!tag.contains("WorldOfTileStored")) {
            return null;
        }
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(tag.getString("WorldOfTileStored")));
    }

    public static BlockPos getStoredPosition(ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        int x = tag.getInt("XCoordOfTileStored");
        int y = tag.getInt("YCoordOfTileStored");
        int z = tag.getInt("ZCoordOfTileStored");
        if (x != 0 || y != 0 || z != 0) {
            return new BlockPos(x, y, z);
        }
        return null;
    }

    public static void clearStorage(ItemStack stack, String ... keys) {
        CompoundTag compound = stack.getOrCreateTag();
        for (String key : keys) {
            compound.remove(key);
        }
    }

    public static void storeConnection(ItemStack stack, int x, int y, int z, Level world) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.putInt("XCoordOfTileStored", x);
        tag.putInt("YCoordOfTileStored", y);
        tag.putInt("ZCoordOfTileStored", z);
        tag.putString("WorldOfTileStored", world.dimension().location().toString());
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
        if (!context.getLevel().isClientSide) {
            BlockPos pos = context.getClickedPos();
            BlockEntity tile = context.getLevel().getBlockEntity(pos);
            if (tile != null && tile instanceof IPhantomTile) {
                BlockPos stored = ItemPhantomConnector.getStoredPosition(stack);
                if (stored != null && ItemPhantomConnector.getStoredWorld(stack) == context.getLevel().dimension()) {
                    ((IPhantomTile)tile).setBoundPosition(stored);
                    if (tile instanceof TileEntityBase) {
                        ((TileEntityBase)tile).sendUpdate();
                    }
                    ItemPhantomConnector.clearStorage(stack, "XCoordOfTileStored", "YCoordOfTileStored", "ZCoordOfTileStored", "WorldOfTileStored");
                    context.getPlayer().displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.phantom.connected.desc"), true);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            ItemPhantomConnector.storeConnection(stack, pos.getX(), pos.getY(), pos.getZ(), context.getLevel());
            context.getPlayer().displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.phantom.stored.desc"), true);
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level playerIn, List<Component> list, TooltipFlag advanced) {
        BlockPos coords = ItemPhantomConnector.getStoredPosition(stack);
        if (coords != null) {
            list.add((Component)Component.translatable((String)"tooltip.actuallyadditions.boundTo.desc").append(":"));
            list.add((Component)Component.literal((String)("X: " + coords.getX())));
            list.add((Component)Component.literal((String)("Y: " + coords.getY())));
            list.add((Component)Component.literal((String)("Z: " + coords.getZ())));
            list.add((Component)Component.translatable((String)"tooltip.actuallyadditions.clearStorage.desc").withStyle(ChatFormatting.ITALIC));
        }
    }
}

