/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemPhantomConnector;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPlayerInterface;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemPlayerProbe
extends ItemBase {
    public ItemPlayerProbe() {
        super(ActuallyItems.defaultProps().stacksTo(1));
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        CompoundTag compound;
        if (!world.isClientSide && (compound = stack.getOrCreateTag()).contains("UUID")) {
            UUID id = compound.getUUID("UUID");
            Player player = world.getPlayerByUUID(id);
            if (player != null) {
                if (player.isShiftKeyDown()) {
                    ItemPhantomConnector.clearStorage(stack, "UUID", "Name");
                    ((Player)entity).displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.playerProbe.disconnect.1"), false);
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.playerProbe.notice"), false);
                }
            } else {
                ItemPhantomConnector.clearStorage(stack, "UUID", "Name");
                ((Player)entity).displayClientMessage((Component)Component.translatable((String)"tooltip.actuallyadditions.playerProbe.disconnect.2"), false);
            }
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.getItemInHand(context.getHand());
        BlockEntity tile = context.getLevel().getBlockEntity(context.getClickedPos());
        if (tile instanceof TileEntityPlayerInterface) {
            TileEntityPlayerInterface face = (TileEntityPlayerInterface)tile;
            CompoundTag compound = stack.getOrCreateTag();
            if (compound.contains("UUID")) {
                if (!context.getLevel().isClientSide) {
                    face.connectedPlayer = compound.getUUID("UUID");
                    face.playerName = compound.getString("Name");
                    face.setChanged();
                    face.sendUpdate();
                    ItemPhantomConnector.clearStorage(stack, "UUID", "Name");
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult interactLivingEntity(ItemStack aStack, Player player, LivingEntity entity, InteractionHand hand) {
        Player playerHit;
        ItemStack stack;
        if (!player.level().isClientSide && StackUtil.isValid(stack = player.getMainHandItem()) && stack.getItem() == this && entity instanceof Player && !(playerHit = (Player)entity).isShiftKeyDown()) {
            CompoundTag compound = stack.getOrCreateTag();
            compound.putString("Name", playerHit.getName().getString());
            compound.putUUID("UUID", playerHit.getUUID());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level playerIn, List<Component> tooltip, TooltipFlag advanced) {
        if (stack.getOrCreateTag().contains("Name")) {
            String name = stack.getOrCreateTag().getString("Name");
            tooltip.add((Component)Component.translatable((String)"tooltip.actuallyadditions.playerProbe.probing").append(": " + name));
        }
    }
}

