/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ItemTeleportStaff
extends ItemEnergy {
    public ItemTeleportStaff() {
        super(250000, 1000);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        HitResult rayTraceResult;
        ItemStack stack = player.getItemInHand(hand);
        if (!(world.isClientSide || (rayTraceResult = player.pick(100.0, 1.0f, false)).getType() != HitResult.Type.BLOCK && rayTraceResult.getType() != HitResult.Type.MISS)) {
            Vec3 location = rayTraceResult.getLocation();
            Vec3 pos = Vec3.atBottomCenterOf((Vec3i)BlockPos.containing((double)location.x, (double)location.y, (double)location.z));
            int baseUse = 200;
            int use = baseUse + (int)((double)baseUse * Math.sqrt(player.blockPosition().distManhattan((Vec3i)BlockPos.containing((double)pos.x, (double)pos.y, (double)pos.z))));
            ActuallyAdditions.LOGGER.info("Use: " + use + " Energy: " + this.getEnergyStored(stack));
            ActuallyAdditions.LOGGER.info("Distance: " + Math.sqrt(player.blockPosition().distSqr((Vec3i)BlockPos.containing((double)pos.x, (double)pos.y, (double)pos.z))));
            ActuallyAdditions.LOGGER.info("Player: " + player.blockPosition());
            ActuallyAdditions.LOGGER.info("Pos: " + pos);
            if (this.getEnergyStored(stack) >= use) {
                ((ServerPlayer)player).connection.teleport(pos.x, pos.y + 1.0, pos.z, player.getYRot(), player.getXRot());
                player.removeVehicle();
                world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.isCreative()) {
                    this.extractEnergyInternal(stack, use, false);
                    player.getCooldowns().addCooldown((Item)this, 50);
                }
                return InteractionResultHolder.success((Object)stack);
            }
        }
        player.swing(hand);
        return InteractionResultHolder.fail((Object)stack);
    }
}

